/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.vector;

import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.BooleanVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherFactory;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.vector.VectorValueSelector;

public class DoubleVectorValueMatcher
implements VectorValueMatcherFactory {
    private final VectorValueSelector selector;
    private final boolean canHaveNulls = !NullHandling.replaceWithDefault();

    public DoubleVectorValueMatcher(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public VectorValueMatcher makeMatcher(@Nullable String value) {
        if (value == null && this.canHaveNulls) {
            return this.makeNullValueMatcher(this.selector);
        }
        Double matchVal = DimensionHandlerUtils.convertObjectToDouble(value);
        if (matchVal == null) {
            return BooleanVectorValueMatcher.of(this.selector, false);
        }
        final double matchValDouble = matchVal;
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[DoubleVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask) {
                double[] vector = DoubleVectorValueMatcher.this.selector.getDoubleVector();
                int[] selection = this.match.getSelection();
                boolean[] nulls = DoubleVectorValueMatcher.this.selector.getNullVector();
                boolean hasNulls = DoubleVectorValueMatcher.this.canHaveNulls && nulls != null;
                int numRows = 0;
                for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    if (hasNulls && nulls[rowNum] || vector[rowNum] != matchValDouble) continue;
                    selection[numRows++] = rowNum;
                }
                this.match.setSelectionSize(numRows);
                assert (this.match.isValid(mask));
                return this.match;
            }
        };
    }

    @Override
    public VectorValueMatcher makeMatcher(DruidPredicateFactory predicateFactory) {
        final DruidDoublePredicate predicate = predicateFactory.makeDoublePredicate();
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[DoubleVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask) {
                double[] vector = DoubleVectorValueMatcher.this.selector.getDoubleVector();
                int[] selection = this.match.getSelection();
                boolean[] nulls = DoubleVectorValueMatcher.this.selector.getNullVector();
                boolean hasNulls = DoubleVectorValueMatcher.this.canHaveNulls && nulls != null;
                int numRows = 0;
                for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    if (hasNulls && nulls[rowNum]) {
                        if (!predicate.applyNull()) continue;
                        selection[numRows++] = rowNum;
                        continue;
                    }
                    if (!predicate.applyDouble(vector[rowNum])) continue;
                    selection[numRows++] = rowNum;
                }
                this.match.setSelectionSize(numRows);
                assert (this.match.isValid(mask));
                return this.match;
            }
        };
    }
}

