/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.vector;

import org.apache.druid.query.filter.vector.DoubleVectorValueMatcher;
import org.apache.druid.query.filter.vector.FloatVectorValueMatcher;
import org.apache.druid.query.filter.vector.LongVectorValueMatcher;
import org.apache.druid.query.filter.vector.MultiValueStringVectorValueMatcher;
import org.apache.druid.query.filter.vector.SingleValueStringVectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherFactory;
import org.apache.druid.segment.VectorColumnProcessorFactory;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class VectorValueMatcherColumnProcessorFactory
implements VectorColumnProcessorFactory<VectorValueMatcherFactory> {
    private static final VectorValueMatcherColumnProcessorFactory INSTANCE = new VectorValueMatcherColumnProcessorFactory();

    private VectorValueMatcherColumnProcessorFactory() {
    }

    public static VectorValueMatcherColumnProcessorFactory instance() {
        return INSTANCE;
    }

    @Override
    public VectorValueMatcherFactory makeSingleValueDimensionProcessor(SingleValueDimensionVectorSelector selector) {
        return new SingleValueStringVectorValueMatcher(selector);
    }

    @Override
    public VectorValueMatcherFactory makeMultiValueDimensionProcessor(MultiValueDimensionVectorSelector selector) {
        return new MultiValueStringVectorValueMatcher(selector);
    }

    @Override
    public VectorValueMatcherFactory makeFloatProcessor(VectorValueSelector selector) {
        return new FloatVectorValueMatcher(selector);
    }

    @Override
    public VectorValueMatcherFactory makeDoubleProcessor(VectorValueSelector selector) {
        return new DoubleVectorValueMatcher(selector);
    }

    @Override
    public VectorValueMatcherFactory makeLongProcessor(VectorValueSelector selector) {
        return new LongVectorValueMatcher(selector);
    }
}

