/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.search;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.IdentityExtractionFn;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.search.CursorOnlyStrategy;
import org.apache.druid.query.search.SearchHit;
import org.apache.druid.query.search.SearchQuery;
import org.apache.druid.query.search.SearchQueryExecutor;
import org.apache.druid.query.search.SearchStrategy;
import org.apache.druid.segment.ColumnSelectorBitmapIndexSelector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.NumericColumn;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class UseIndexesStrategy
extends SearchStrategy {
    public static final String NAME = "useIndexes";

    public static UseIndexesStrategy of(SearchQuery query) {
        return new UseIndexesStrategy(query);
    }

    private UseIndexesStrategy(SearchQuery query) {
        super(query);
    }

    @Override
    public List<SearchQueryExecutor> getExecutionPlan(SearchQuery query, Segment segment) {
        ImmutableList.Builder builder = ImmutableList.builder();
        QueryableIndex index = segment.asQueryableIndex();
        StorageAdapter adapter = segment.asStorageAdapter();
        List<DimensionSpec> searchDims = UseIndexesStrategy.getDimsToSearch(adapter.getAvailableDimensions(), query.getDimensions());
        if (index != null) {
            Pair<List<DimensionSpec>, List<DimensionSpec>> pair = UseIndexesStrategy.partitionDimensionList(adapter, searchDims);
            List bitmapSuppDims = (List)pair.lhs;
            List nonBitmapSuppDims = (List)pair.rhs;
            if (bitmapSuppDims.size() > 0) {
                ColumnSelectorBitmapIndexSelector selector = new ColumnSelectorBitmapIndexSelector(index.getBitmapFactoryForDimensions(), VirtualColumns.EMPTY, index);
                if (this.filter == null || this.filter.supportsBitmapIndex(selector)) {
                    ImmutableBitmap timeFilteredBitmap = UseIndexesStrategy.makeTimeFilteredBitmap(index, segment, this.filter, this.interval);
                    builder.add((Object)new IndexOnlyExecutor(query, segment, timeFilteredBitmap, bitmapSuppDims));
                } else {
                    nonBitmapSuppDims.addAll(bitmapSuppDims);
                }
            }
            if (nonBitmapSuppDims.size() > 0) {
                builder.add((Object)new CursorOnlyStrategy.CursorBasedExecutor(query, segment, this.filter, this.interval, nonBitmapSuppDims));
            }
        } else {
            builder.add((Object)new CursorOnlyStrategy.CursorBasedExecutor(query, segment, this.filter, this.interval, searchDims));
        }
        return builder.build();
    }

    private static Pair<List<DimensionSpec>, List<DimensionSpec>> partitionDimensionList(StorageAdapter adapter, List<DimensionSpec> dimensions) {
        ArrayList<DimensionSpec> bitmapDims = new ArrayList<DimensionSpec>();
        ArrayList<DimensionSpec> nonBitmapDims = new ArrayList<DimensionSpec>();
        List<DimensionSpec> dimsToSearch = UseIndexesStrategy.getDimsToSearch(adapter.getAvailableDimensions(), dimensions);
        for (DimensionSpec spec : dimsToSearch) {
            ColumnCapabilities capabilities = adapter.getColumnCapabilities(spec.getDimension());
            if (capabilities == null) continue;
            if (capabilities.hasBitmapIndexes()) {
                bitmapDims.add(spec);
                continue;
            }
            nonBitmapDims.add(spec);
        }
        return new Pair(bitmapDims, nonBitmapDims);
    }

    static ImmutableBitmap makeTimeFilteredBitmap(QueryableIndex index, Segment segment, Filter filter, Interval interval) {
        ImmutableBitmap timeFilteredBitmap;
        ImmutableBitmap baseFilter;
        BitmapFactory bitmapFactory = index.getBitmapFactoryForDimensions();
        if (filter == null) {
            baseFilter = null;
        } else {
            ColumnSelectorBitmapIndexSelector selector = new ColumnSelectorBitmapIndexSelector(index.getBitmapFactoryForDimensions(), VirtualColumns.EMPTY, index);
            Preconditions.checkArgument((boolean)filter.supportsBitmapIndex(selector), (String)"filter[%s] should support bitmap", (Object[])new Object[]{filter});
            baseFilter = filter.getBitmapIndex(selector);
        }
        if (!interval.contains((ReadableInterval)segment.getDataInterval())) {
            MutableBitmap timeBitmap = bitmapFactory.makeEmptyMutableBitmap();
            ColumnHolder timeColumnHolder = index.getColumnHolder("__time");
            try (NumericColumn timeValues = (NumericColumn)timeColumnHolder.getColumn();){
                int startIndex = Math.max(0, UseIndexesStrategy.getStartIndexOfTime(timeValues, interval.getStartMillis(), true));
                int endIndex = Math.min(timeValues.length() - 1, UseIndexesStrategy.getStartIndexOfTime(timeValues, interval.getEndMillis(), false));
                for (int i = startIndex; i <= endIndex; ++i) {
                    timeBitmap.add(i);
                }
                ImmutableBitmap finalTimeBitmap = bitmapFactory.makeImmutableBitmap(timeBitmap);
                timeFilteredBitmap = baseFilter == null ? finalTimeBitmap : finalTimeBitmap.intersection(baseFilter);
            }
        } else {
            timeFilteredBitmap = baseFilter;
        }
        return timeFilteredBitmap;
    }

    private static int getStartIndexOfTime(NumericColumn timeValues, long time, boolean inclusive) {
        int low = 0;
        int high = timeValues.length() - 1;
        while (low <= high) {
            long prev;
            int i;
            int mid = low + high >>> 1;
            long midVal = timeValues.getLongSingleValueRow(mid);
            if (midVal < time) {
                low = mid + 1;
                continue;
            }
            if (midVal > time) {
                high = mid - 1;
                continue;
            }
            for (i = mid - 1; i >= 0 && time == (prev = timeValues.getLongSingleValueRow(i)); --i) {
            }
            return inclusive ? i + 1 : i;
        }
        return inclusive ? low : low - 1;
    }

    public static class IndexOnlyExecutor
    extends SearchQueryExecutor {
        private final ImmutableBitmap timeFilteredBitmap;

        public IndexOnlyExecutor(SearchQuery query, Segment segment, ImmutableBitmap timeFilteredBitmap, List<DimensionSpec> dimensionSpecs) {
            super(query, segment, dimensionSpecs);
            this.timeFilteredBitmap = timeFilteredBitmap;
        }

        @Override
        public Object2IntRBTreeMap<SearchHit> execute(int limit) {
            QueryableIndex index = this.segment.asQueryableIndex();
            Preconditions.checkArgument((index != null ? 1 : 0) != 0, (Object)"Index should not be null");
            Object2IntRBTreeMap retVal = new Object2IntRBTreeMap(this.query.getSort().getComparator());
            retVal.defaultReturnValue(0);
            BitmapFactory bitmapFactory = index.getBitmapFactoryForDimensions();
            for (DimensionSpec dimension : this.dimsToSearch) {
                ColumnHolder columnHolder = index.getColumnHolder(dimension.getDimension());
                if (columnHolder == null) continue;
                BitmapIndex bitmapIndex = columnHolder.getBitmapIndex();
                Preconditions.checkArgument((bitmapIndex != null ? 1 : 0) != 0, (String)"Dimension [%s] should support bitmap index", (Object[])new Object[]{dimension.getDimension()});
                ExtractionFn extractionFn = dimension.getExtractionFn();
                if (extractionFn == null) {
                    extractionFn = IdentityExtractionFn.getInstance();
                }
                for (int i = 0; i < bitmapIndex.getCardinality(); ++i) {
                    String dimVal = extractionFn.apply(bitmapIndex.getValue(i));
                    if (!this.searchQuerySpec.accept(dimVal)) continue;
                    ImmutableBitmap bitmap = bitmapIndex.getBitmap(i);
                    if (this.timeFilteredBitmap != null) {
                        bitmap = bitmapFactory.intersection(Arrays.asList(this.timeFilteredBitmap, bitmap));
                    }
                    if (bitmap.isEmpty()) continue;
                    retVal.addTo((Object)new SearchHit(dimension.getOutputName(), dimVal), bitmap.size());
                    if (retVal.size() < limit) continue;
                    return retVal;
                }
            }
            return retVal;
        }
    }
}

