/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.function.ToLongFunction;
import javax.annotation.Nullable;
import org.apache.druid.segment.RowAdapter;
import org.joda.time.DateTime;

public class RowWalker<T> {
    private final Iterable<T> rowIterable;
    private final ToLongFunction<T> timestampFunction;
    private Iterator<T> rowIterator;
    @Nullable
    private T current = null;

    RowWalker(Iterable<T> rowIterable, RowAdapter<T> rowAdapter) {
        this.rowIterable = rowIterable;
        this.timestampFunction = rowAdapter.timestampFunction();
        this.reset();
    }

    public boolean isDone() {
        return this.current == null;
    }

    public T currentRow() {
        return (T)Preconditions.checkNotNull(this.current, (Object)"cannot call currentRow when isDone == true");
    }

    public void advance() {
        if (this.rowIterator.hasNext()) {
            this.current = this.rowIterator.next();
            if (this.current == null) {
                throw new NullPointerException("null row encountered in walker");
            }
        } else {
            this.current = null;
        }
    }

    public void reset() {
        this.rowIterator = this.rowIterable.iterator();
        this.advance();
    }

    public void skipToDateTime(DateTime timestamp, boolean descending) {
        while (this.current != null && (descending ? timestamp.isBefore(this.timestampFunction.applyAsLong(this.current)) : timestamp.isAfter(this.timestampFunction.applyAsLong(this.current)))) {
            this.advance();
        }
    }
}

