/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter.cnf;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.druid.query.filter.BooleanFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.NotFilter;
import org.apache.druid.segment.filter.OrFilter;

public class HiveCnfHelper {
    public static Filter pushDownNot(Filter current) {
        HashSet<Filter> children;
        if (current instanceof NotFilter) {
            Filter child = ((NotFilter)current).getBaseFilter();
            if (child instanceof NotFilter) {
                return HiveCnfHelper.pushDownNot(((NotFilter)child).getBaseFilter());
            }
            if (child instanceof AndFilter) {
                HashSet<Filter> children2 = new HashSet<Filter>();
                for (Filter grandChild : ((AndFilter)child).getFilters()) {
                    children2.add(HiveCnfHelper.pushDownNot(new NotFilter(grandChild)));
                }
                return new OrFilter(children2);
            }
            if (child instanceof OrFilter) {
                HashSet<Filter> children3 = new HashSet<Filter>();
                for (Filter grandChild : ((OrFilter)child).getFilters()) {
                    children3.add(HiveCnfHelper.pushDownNot(new NotFilter(grandChild)));
                }
                return new AndFilter(children3);
            }
        }
        if (current instanceof AndFilter) {
            children = new HashSet<Filter>();
            for (Filter child : ((AndFilter)current).getFilters()) {
                children.add(HiveCnfHelper.pushDownNot(child));
            }
            return new AndFilter(children);
        }
        if (current instanceof OrFilter) {
            children = new HashSet();
            for (Filter child : ((OrFilter)current).getFilters()) {
                children.add(HiveCnfHelper.pushDownNot(child));
            }
            return new OrFilter(children);
        }
        return current;
    }

    public static Filter convertToCnf(Filter current) {
        if (current instanceof NotFilter) {
            return new NotFilter(HiveCnfHelper.convertToCnf(((NotFilter)current).getBaseFilter()));
        }
        if (current instanceof AndFilter) {
            HashSet<Filter> children = new HashSet<Filter>();
            for (Filter child : ((AndFilter)current).getFilters()) {
                children.add(HiveCnfHelper.convertToCnf(child));
            }
            return new AndFilter(children);
        }
        if (current instanceof OrFilter) {
            ArrayList<Filter> nonAndList = new ArrayList<Filter>();
            ArrayList<Filter> andList = new ArrayList<Filter>();
            for (Filter child : ((OrFilter)current).getFilters()) {
                if (child instanceof AndFilter) {
                    andList.add(child);
                    continue;
                }
                if (child instanceof OrFilter) {
                    nonAndList.addAll(((OrFilter)child).getFilters());
                    continue;
                }
                nonAndList.add(child);
            }
            if (!andList.isEmpty()) {
                HashSet<Filter> result = new HashSet<Filter>();
                HiveCnfHelper.generateAllCombinations(result, andList, nonAndList);
                return new AndFilter(result);
            }
        }
        return current;
    }

    public static Filter flatten(Filter root) {
        if (root instanceof BooleanFilter) {
            ArrayList<Filter> children = new ArrayList<Filter>(((BooleanFilter)root).getFilters());
            for (int i = 0; i < children.size(); ++i) {
                Filter child = HiveCnfHelper.flatten((Filter)children.get(i));
                if (child.getClass() == root.getClass() && !(child instanceof NotFilter)) {
                    boolean first = true;
                    Set<Filter> grandKids = ((BooleanFilter)child).getFilters();
                    for (Filter grandkid : grandKids) {
                        if (first) {
                            first = false;
                            children.set(i, grandkid);
                            continue;
                        }
                        children.add(++i, grandkid);
                    }
                    continue;
                }
                children.set(i, child);
            }
            if (children.size() == 1 && (root instanceof AndFilter || root instanceof OrFilter)) {
                return (Filter)children.get(0);
            }
            if (root instanceof AndFilter) {
                return new AndFilter(children);
            }
            if (root instanceof OrFilter) {
                return new OrFilter(children);
            }
        }
        return root;
    }

    private static void generateAllCombinations(Set<Filter> result, List<Filter> andList, List<Filter> nonAndList) {
        Set<Filter> children = ((AndFilter)andList.get(0)).getFilters();
        if (result.isEmpty()) {
            for (Filter child : children) {
                HashSet<Filter> a = new HashSet<Filter>(nonAndList);
                a.add(child);
                result.add(new OrFilter(a));
            }
        } else {
            ArrayList<Filter> work = new ArrayList<Filter>(result);
            result.clear();
            for (Filter child : children) {
                for (Filter or : work) {
                    HashSet<Filter> a = new HashSet<Filter>(((OrFilter)or).getFilters());
                    a.add(child);
                    result.add(new OrFilter(a));
                }
            }
        }
        if (andList.size() > 1) {
            HiveCnfHelper.generateAllCombinations(result, andList.subList(1, andList.size()), nonAndList);
        }
    }

    private HiveCnfHelper() {
    }
}

