/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;

public class VirtualizedColumnSelectorFactory
implements ColumnSelectorFactory {
    private final ColumnSelectorFactory baseFactory;
    private final VirtualColumns virtualColumns;

    public VirtualizedColumnSelectorFactory(ColumnSelectorFactory baseFactory, VirtualColumns virtualColumns) {
        this.baseFactory = (ColumnSelectorFactory)Preconditions.checkNotNull((Object)baseFactory, (Object)"baseFactory");
        this.virtualColumns = (VirtualColumns)Preconditions.checkNotNull((Object)virtualColumns, (Object)"virtualColumns");
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        if (this.virtualColumns.exists(dimensionSpec.getDimension())) {
            return this.virtualColumns.makeDimensionSelector(dimensionSpec, this.baseFactory);
        }
        return this.baseFactory.makeDimensionSelector(dimensionSpec);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeColumnValueSelector(columnName, this.baseFactory);
        }
        return this.baseFactory.makeColumnValueSelector(columnName);
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.getColumnCapabilities(columnName);
        }
        return this.baseFactory.getColumnCapabilities(columnName);
    }
}

