/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import java.util.Base64;
import javax.annotation.Nullable;
import org.apache.druid.data.input.RetryingInputEntity;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.PasswordProvider;

public class HttpEntity
extends RetryingInputEntity {
    private static final Logger LOG = new Logger(HttpEntity.class);
    private final URI uri;
    @Nullable
    private final String httpAuthenticationUsername;
    @Nullable
    private final PasswordProvider httpAuthenticationPasswordProvider;

    HttpEntity(URI uri, @Nullable String httpAuthenticationUsername, @Nullable PasswordProvider httpAuthenticationPasswordProvider) {
        this.uri = uri;
        this.httpAuthenticationUsername = httpAuthenticationUsername;
        this.httpAuthenticationPasswordProvider = httpAuthenticationPasswordProvider;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    protected InputStream readFrom(long offset) throws IOException {
        return HttpEntity.openInputStream(this.uri, this.httpAuthenticationUsername, this.httpAuthenticationPasswordProvider, offset);
    }

    @Override
    protected String getPath() {
        return this.uri.getPath();
    }

    @Override
    public Predicate<Throwable> getRetryCondition() {
        return t -> t instanceof IOException;
    }

    public static InputStream openInputStream(URI object, String userName, PasswordProvider passwordProvider, long offset) throws IOException {
        InputStream in;
        long skipped;
        String acceptRanges;
        boolean withRanges;
        URLConnection urlConnection = object.toURL().openConnection();
        if (!Strings.isNullOrEmpty((String)userName) && passwordProvider != null) {
            String userPass = userName + ":" + passwordProvider.getPassword();
            String basicAuthString = "Basic " + Base64.getEncoder().encodeToString(StringUtils.toUtf8(userPass));
            urlConnection.setRequestProperty("Authorization", basicAuthString);
        }
        if ((withRanges = "bytes".equalsIgnoreCase(acceptRanges = urlConnection.getHeaderField("Accept-Ranges"))) && offset > 0L) {
            urlConnection.addRequestProperty("Range", StringUtils.format("bytes=%d-", offset));
            return urlConnection.getInputStream();
        }
        if (!withRanges && offset > 0L) {
            LOG.warn("Since the input source doesn't support range requests, the object input stream is opened from the start and then skipped. This may make the ingestion speed slower. Consider enabling prefetch if you see this message a lot.", new Object[0]);
        }
        if ((skipped = (in = urlConnection.getInputStream()).skip(offset)) != offset) {
            throw new ISE("Requested to skip [%s] bytes, but actual number of bytes skipped is [%s]", offset, skipped);
        }
        return in;
    }
}

