/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.data.input.AbstractInputSource;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.InputEntityIteratingReader;
import org.apache.druid.java.util.common.StringUtils;

public class InlineInputSource
extends AbstractInputSource {
    private final String data;

    @JsonCreator
    public InlineInputSource(@JsonProperty(value="data") String data) {
        Preconditions.checkArgument((data != null && !data.isEmpty() ? 1 : 0) != 0, (Object)"empty data");
        this.data = data;
    }

    @JsonProperty
    public String getData() {
        return this.data;
    }

    @Override
    public boolean isSplittable() {
        return false;
    }

    @Override
    public boolean needsFormat() {
        return true;
    }

    @Override
    protected InputSourceReader formattableReader(InputRowSchema inputRowSchema, InputFormat inputFormat, @Nullable File temporaryDirectory) {
        return new InputEntityIteratingReader(inputRowSchema, inputFormat, Stream.of(new ByteEntity(StringUtils.toUtf8(this.data))).iterator(), temporaryDirectory);
    }
}

