/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.core;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.emitter.core.BatchingStrategy;
import org.apache.druid.java.util.emitter.core.ContentEncoding;
import org.apache.druid.metadata.PasswordProvider;
import org.apache.druid.utils.JvmUtils;

public class BaseHttpEmittingConfig {
    public static final long DEFAULT_FLUSH_MILLIS = 60000L;
    public static final int DEFAULT_FLUSH_COUNTS = 500;
    public static final int DEFAULT_MAX_BATCH_SIZE;
    public static final int DEFAULT_BATCH_QUEUE_SIZE_LIMIT;
    public static final long TEST_FLUSH_TIMEOUT_MILLIS;
    public static final long DEFAULT_FLUSH_TIME_OUT = Long.MAX_VALUE;
    public static final BatchingStrategy DEFAULT_BATCHING_STRATEGY;
    public static final ContentEncoding DEFAULT_CONTENT_ENCODING;
    public static final float DEFAULT_HTTP_TIMEOUT_ALLOWANCE_FACTOR = 2.0f;
    public static final int DEFAULT_MIN_HTTP_TIMEOUT_MILLIS = 0;
    @Min(value=1L)
    @JsonProperty
    long flushMillis = 60000L;
    @Min(value=0L)
    @JsonProperty
    int flushCount = 500;
    @Min(value=0L)
    @JsonProperty
    long flushTimeOut = Long.MAX_VALUE;
    @JsonProperty
    PasswordProvider basicAuthentication = null;
    @JsonProperty
    BatchingStrategy batchingStrategy = DEFAULT_BATCHING_STRATEGY;
    @Min(value=0L)
    @JsonProperty
    int maxBatchSize = DEFAULT_MAX_BATCH_SIZE;
    @JsonProperty
    ContentEncoding contentEncoding = DEFAULT_CONTENT_ENCODING;
    @Min(value=0L)
    @JsonProperty
    int batchQueueSizeLimit = DEFAULT_BATCH_QUEUE_SIZE_LIMIT;
    @Min(value=1L)
    @JsonProperty
    float httpTimeoutAllowanceFactor = 2.0f;
    @Min(value=0L)
    @JsonProperty
    int minHttpTimeoutMillis = 0;

    public static Pair<Integer, Integer> getDefaultBatchSizeAndLimit(long maxMemory) {
        long batchSize = 0x500000L;
        long queueLimit = 50L;
        long memoryLimit = maxMemory / 10L;
        if (batchSize * queueLimit > memoryLimit) {
            queueLimit = memoryLimit / batchSize;
        }
        if (queueLimit < 2L) {
            queueLimit = 2L;
            batchSize = memoryLimit / queueLimit;
        }
        return new Pair<Integer, Integer>((int)batchSize, (int)queueLimit);
    }

    public long getFlushMillis() {
        return this.flushMillis;
    }

    public int getFlushCount() {
        return this.flushCount;
    }

    public long getFlushTimeOut() {
        return this.flushTimeOut;
    }

    public PasswordProvider getBasicAuthentication() {
        return this.basicAuthentication;
    }

    public BatchingStrategy getBatchingStrategy() {
        return this.batchingStrategy;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public ContentEncoding getContentEncoding() {
        return this.contentEncoding;
    }

    public int getBatchQueueSizeLimit() {
        return this.batchQueueSizeLimit;
    }

    public float getHttpTimeoutAllowanceFactor() {
        return this.httpTimeoutAllowanceFactor;
    }

    public int getMinHttpTimeoutMillis() {
        return this.minHttpTimeoutMillis;
    }

    public String toString() {
        return "BaseHttpEmittingConfig{" + this.toStringBase() + '}';
    }

    protected String toStringBase() {
        return "flushMillis=" + this.flushMillis + ", flushCount=" + this.flushCount + ", flushTimeOut=" + this.flushTimeOut + ", basicAuthentication='" + this.basicAuthentication + '\'' + ", batchingStrategy=" + (Object)((Object)this.batchingStrategy) + ", maxBatchSize=" + this.maxBatchSize + ", contentEncoding=" + (Object)((Object)this.contentEncoding) + ", batchQueueSizeLimit=" + this.batchQueueSizeLimit + ", httpTimeoutAllowanceFactor=" + this.httpTimeoutAllowanceFactor + ", minHttpTimeoutMillis=" + this.minHttpTimeoutMillis;
    }

    static {
        TEST_FLUSH_TIMEOUT_MILLIS = TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS);
        Pair<Integer, Integer> batchConfigPair = BaseHttpEmittingConfig.getDefaultBatchSizeAndLimit(JvmUtils.getRuntimeInfo().getMaxHeapSizeBytes());
        DEFAULT_MAX_BATCH_SIZE = (Integer)batchConfigPair.lhs;
        DEFAULT_BATCH_QUEUE_SIZE_LIMIT = (Integer)batchConfigPair.rhs;
        DEFAULT_BATCHING_STRATEGY = BatchingStrategy.ARRAY;
        DEFAULT_CONTENT_ENCODING = null;
    }
}

