/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline;

public interface Overshadowable<T extends Overshadowable> {
    default public boolean overshadows(T other) {
        int majorVersionCompare = this.getVersion().compareTo(other.getVersion());
        if (majorVersionCompare == 0) {
            return this.containsRootPartition(other) && this.getMinorVersion() > other.getMinorVersion();
        }
        return majorVersionCompare > 0;
    }

    default public boolean containsRootPartition(T other) {
        return this.getStartRootPartitionId() <= other.getStartRootPartitionId() && this.getEndRootPartitionId() >= other.getEndRootPartitionId();
    }

    public int getStartRootPartitionId();

    public int getEndRootPartitionId();

    public String getVersion();

    public short getMinorVersion();

    public short getAtomicUpdateGroupSize();
}

