/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.expressions.translator;

import com.facebook.presto.expressions.translator.RowExpressionTranslator;
import com.facebook.presto.expressions.translator.TranslatedExpression;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import java.util.Objects;

public class RowExpressionTreeTranslator<T, C> {
    private final RowExpressionTranslator<T, C> rowExpressionTranslator;
    private final RowExpressionVisitor<TranslatedExpression<T>, C> visitor;

    private RowExpressionTreeTranslator(RowExpressionTranslator<T, C> rowExpressionTranslator) {
        this.rowExpressionTranslator = Objects.requireNonNull(rowExpressionTranslator, "rowExpressionTranslator is null");
        this.visitor = new TranslatingVisitor();
    }

    public TranslatedExpression<T> rewrite(RowExpression node, C context) {
        return (TranslatedExpression)node.accept(this.visitor, context);
    }

    public static <T, C> TranslatedExpression<T> translateWith(RowExpression expression, RowExpressionTranslator<T, C> translator, C context) {
        return (TranslatedExpression)expression.accept(new RowExpressionTreeTranslator<T, C>(translator).visitor, context);
    }

    private class TranslatingVisitor
    implements RowExpressionVisitor<TranslatedExpression<T>, C> {
        private TranslatingVisitor() {
        }

        public TranslatedExpression<T> visitCall(CallExpression call, C context) {
            return RowExpressionTreeTranslator.this.rowExpressionTranslator.translateCall(call, context, RowExpressionTreeTranslator.this);
        }

        public TranslatedExpression<T> visitInputReference(InputReferenceExpression reference, C context) {
            throw new UnsupportedOperationException("Cannot translate RowExpression that contains inputReferenceExpression");
        }

        public TranslatedExpression<T> visitConstant(ConstantExpression literal, C context) {
            return RowExpressionTreeTranslator.this.rowExpressionTranslator.translateConstant(literal, context, RowExpressionTreeTranslator.this);
        }

        public TranslatedExpression<T> visitLambda(LambdaDefinitionExpression lambda, C context) {
            return RowExpressionTreeTranslator.this.rowExpressionTranslator.translateLambda(lambda, context, RowExpressionTreeTranslator.this);
        }

        public TranslatedExpression<T> visitVariableReference(VariableReferenceExpression reference, C context) {
            return RowExpressionTreeTranslator.this.rowExpressionTranslator.translateVariable(reference, context, RowExpressionTreeTranslator.this);
        }

        public TranslatedExpression<T> visitSpecialForm(SpecialFormExpression specialForm, C context) {
            return RowExpressionTreeTranslator.this.rowExpressionTranslator.translateSpecialForm(specialForm, context, RowExpressionTreeTranslator.this);
        }
    }
}

