/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core;

import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseResponse {
    public static String getContentMD5(HttpURLConnection request) {
        return request.getHeaderField("Content-MD5");
    }

    public static String getDate(HttpURLConnection request) {
        String retString = request.getHeaderField("Date");
        return retString == null ? request.getHeaderField("x-ms-date") : retString;
    }

    public static String getEtag(HttpURLConnection request) {
        return request.getHeaderField("ETag");
    }

    public static HashMap<String, String> getMetadata(HttpURLConnection request) {
        return BaseResponse.getValuesByHeaderPrefix(request, "x-ms-meta-");
    }

    public static String getRequestId(HttpURLConnection request) {
        return request.getHeaderField("x-ms-request-id");
    }

    private static HashMap<String, String> getValuesByHeaderPrefix(HttpURLConnection request, String prefix) {
        HashMap<String, String> retVals = new HashMap<String, String>();
        Map<String, List<String>> headerMap = request.getHeaderFields();
        int prefixLength = prefix.length();
        for (Map.Entry<String, List<String>> entry : headerMap.entrySet()) {
            if (entry.getKey() == null || !entry.getKey().startsWith(prefix)) continue;
            List<String> currHeaderValues = entry.getValue();
            retVals.put(entry.getKey().substring(prefixLength), currHeaderValues.get(0));
        }
        return retVals;
    }

    protected BaseResponse() {
    }
}

