/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.zip;

import com.facebook.presto.druid.DataInputSource;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.zip.ExtraData;
import com.facebook.presto.druid.zip.ExtraDataList;
import com.facebook.presto.druid.zip.ZipFileData;
import com.facebook.presto.druid.zip.ZipFileEntry;
import com.facebook.presto.druid.zip.ZipUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.io.IOException;
import java.nio.charset.Charset;

public class CentralDirectoryFileHeader {
    static final int SIGNATURE = 33639248;
    static final int FIXED_DATA_SIZE = 46;
    static final int VERSION_OFFSET = 4;
    static final int VERSION_NEEDED_OFFSET = 6;
    static final int FLAGS_OFFSET = 8;
    static final int METHOD_OFFSET = 10;
    static final int MOD_TIME_OFFSET = 12;
    static final int CRC_OFFSET = 16;
    static final int COMPRESSED_SIZE_OFFSET = 20;
    static final int UNCOMPRESSED_SIZE_OFFSET = 24;
    static final int FILENAME_LENGTH_OFFSET = 28;
    static final int EXTRA_FIELD_LENGTH_OFFSET = 30;
    static final int COMMENT_LENGTH_OFFSET = 32;
    static final int INTERNAL_ATTRIBUTES_OFFSET = 36;
    static final int EXTERNAL_ATTRIBUTES_OFFSET = 38;
    static final int LOCAL_HEADER_OFFSET_OFFSET = 42;

    private CentralDirectoryFileHeader() {
    }

    public static long read(ZipFileData fileData, DataInputSource dataInputSource, long fileOffset, Charset charset) throws IOException {
        ExtraData zip64Extra;
        long position = fileOffset;
        byte[] fixedSizeData = new byte[46];
        dataInputSource.readFully(position, fixedSizeData);
        position += (long)fixedSizeData.length;
        if (!ZipUtil.arrayStartsWith(fixedSizeData, ZipUtil.intToLittleEndian(33639248))) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, String.format("Malformed Central Directory File Header; does not start with %08x", 33639248));
        }
        byte[] name = new byte[ZipUtil.getUnsignedShort(fixedSizeData, 28)];
        byte[] extraField = new byte[ZipUtil.getUnsignedShort(fixedSizeData, 30)];
        byte[] comment = new byte[ZipUtil.getUnsignedShort(fixedSizeData, 32)];
        if (name.length > 0) {
            dataInputSource.readFully(position, name);
            position += (long)name.length;
        }
        if (extraField.length > 0) {
            dataInputSource.readFully(position, extraField);
            position += (long)extraField.length;
        }
        if (comment.length > 0) {
            dataInputSource.readFully(position, comment);
            position += (long)extraField.length;
        }
        ExtraDataList extra = new ExtraDataList(extraField);
        long csize = ZipUtil.getUnsignedInt(fixedSizeData, 20);
        long size = ZipUtil.getUnsignedInt(fixedSizeData, 24);
        long offset = ZipUtil.getUnsignedInt(fixedSizeData, 42);
        if ((csize == 0xFFFFFFFFL || size == 0xFFFFFFFFL || offset == 0xFFFFFFFFL) && (zip64Extra = extra.get((short)1)) != null) {
            int index = 0;
            if (size == 0xFFFFFFFFL) {
                size = ZipUtil.getUnsignedLong(zip64Extra.getData(), index);
                index += 8;
            }
            if (csize == 0xFFFFFFFFL) {
                csize = ZipUtil.getUnsignedLong(zip64Extra.getData(), index);
                index += 8;
            }
            if (offset == 0xFFFFFFFFL) {
                offset = ZipUtil.getUnsignedLong(zip64Extra.getData(), index);
                index += 8;
            }
        }
        ZipFileEntry entry = new ZipFileEntry(new String(name, charset));
        entry.setVersion(ZipUtil.get16(fixedSizeData, 4));
        entry.setVersionNeeded(ZipUtil.get16(fixedSizeData, 6));
        entry.setFlags(ZipUtil.get16(fixedSizeData, 8));
        entry.setMethod(ZipFileEntry.Compression.fromValue(ZipUtil.get16(fixedSizeData, 10)));
        long time = ZipUtil.dosToUnixTime(ZipUtil.get32(fixedSizeData, 12));
        entry.setTime(ZipUtil.isValidInDos(time) ? time : ZipUtil.DOS_EPOCH);
        entry.setCrc(ZipUtil.getUnsignedInt(fixedSizeData, 16));
        entry.setCompressedSize(csize);
        entry.setSize(size);
        entry.setInternalAttributes(ZipUtil.get16(fixedSizeData, 36));
        entry.setExternalAttributes(ZipUtil.get32(fixedSizeData, 38));
        entry.setLocalHeaderOffset(offset);
        entry.setExtra(extra);
        entry.setComment(new String(comment, charset));
        fileData.addEntry(entry);
        return position - fileOffset;
    }
}

