/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.collect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class Utils {
    public static <K, V> Map<K, V> zipMapPartial(Iterable<K> keys, Iterable<V> values) {
        LinkedHashMap<K, V> retVal = new LinkedHashMap<K, V>();
        Iterator<K> keysIter = keys.iterator();
        Iterator<V> valsIter = values.iterator();
        while (keysIter.hasNext()) {
            K key = keysIter.next();
            if (!valsIter.hasNext()) break;
            retVal.put(key, valsIter.next());
        }
        return retVal;
    }

    @SafeVarargs
    public static <T> List<T> nullableListOf(T ... elements) {
        ArrayList<T> list;
        if (elements == null) {
            list = new ArrayList<T>(1);
            list.add(null);
        } else {
            list = new ArrayList(elements.length);
            list.addAll(Arrays.asList(elements));
        }
        return list;
    }

    public static <T> boolean isPrefix(List<T> small, List<T> big) {
        for (int i = 0; i < small.size(); ++i) {
            if (small.get(i).equals(big.get(i))) continue;
            return false;
        }
        return true;
    }

    public static String safeObjectClassGetName(@Nullable Object o) {
        if (o == null) {
            return "NULL";
        }
        return o.getClass().getName();
    }
}

