/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;

public class ExprMacroTable {
    private static final ExprMacroTable NIL = new ExprMacroTable(Collections.emptyList());
    private final Map<String, ExprMacro> macroMap;

    public ExprMacroTable(List<ExprMacro> macros) {
        this.macroMap = macros.stream().collect(Collectors.toMap(m -> StringUtils.toLowerCase(m.name()), m -> m));
    }

    public static ExprMacroTable nil() {
        return NIL;
    }

    public List<ExprMacro> getMacros() {
        return ImmutableList.copyOf(this.macroMap.values());
    }

    @Nullable
    public Expr get(String functionName, List<Expr> args) {
        ExprMacro exprMacro = this.macroMap.get(StringUtils.toLowerCase(functionName));
        if (exprMacro == null) {
            return null;
        }
        return exprMacro.apply(args);
    }

    public static abstract class BaseScalarMacroFunctionExpr
    implements Expr {
        protected final String name;
        protected final List<Expr> args;
        private final Supplier<Expr.BindingDetails> analyzeInputsSupplier;

        public BaseScalarMacroFunctionExpr(String name, List<Expr> args) {
            this.name = name;
            this.args = args;
            this.analyzeInputsSupplier = Suppliers.memoize(this::supplyAnalyzeInputs);
        }

        @Override
        public String stringify() {
            return StringUtils.format("%s(%s)", this.name, Expr.ARG_JOINER.join(this.args.stream().map(Expr::stringify).iterator()));
        }

        @Override
        public void visit(Expr.Visitor visitor) {
            for (Expr arg : this.args) {
                arg.visit(visitor);
            }
            visitor.visit(this);
        }

        @Override
        public Expr.BindingDetails analyzeInputs() {
            return (Expr.BindingDetails)this.analyzeInputsSupplier.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseScalarMacroFunctionExpr that = (BaseScalarMacroFunctionExpr)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.args, that.args);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.args);
        }

        private Expr.BindingDetails supplyAnalyzeInputs() {
            HashSet argSet = Sets.newHashSetWithExpectedSize((int)this.args.size());
            Expr.BindingDetails accumulator = new Expr.BindingDetails();
            for (Expr arg : this.args) {
                accumulator = accumulator.with(arg);
                argSet.add(arg);
            }
            return accumulator.withScalarArguments(argSet);
        }
    }

    public static abstract class BaseScalarUnivariateMacroFunctionExpr
    implements Expr {
        protected final String name;
        protected final Expr arg;
        private final Supplier<Expr.BindingDetails> analyzeInputsSupplier;

        public BaseScalarUnivariateMacroFunctionExpr(String name, Expr arg) {
            this.name = name;
            this.arg = arg;
            this.analyzeInputsSupplier = Suppliers.memoize(this::supplyAnalyzeInputs);
        }

        @Override
        public void visit(Expr.Visitor visitor) {
            this.arg.visit(visitor);
            visitor.visit(this);
        }

        @Override
        public Expr.BindingDetails analyzeInputs() {
            return (Expr.BindingDetails)this.analyzeInputsSupplier.get();
        }

        @Override
        public String stringify() {
            return StringUtils.format("%s(%s)", this.name, this.arg.stringify());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseScalarUnivariateMacroFunctionExpr that = (BaseScalarUnivariateMacroFunctionExpr)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.arg, that.arg);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.arg);
        }

        private Expr.BindingDetails supplyAnalyzeInputs() {
            return this.arg.analyzeInputs().withScalarArguments((Set<Expr>)ImmutableSet.of((Object)this.arg));
        }
    }

    public static interface ExprMacro {
        public String name();

        public Expr apply(List<Expr> var1);
    }
}

