/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ConstantExpr;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;

class StringArrayExpr
extends ConstantExpr {
    private final String[] value;

    StringArrayExpr(String[] value) {
        this.value = (String[])Preconditions.checkNotNull((Object)value, (Object)"value");
    }

    @Override
    public Object getLiteralValue() {
        return this.value;
    }

    public String toString() {
        return Arrays.toString(this.value);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return ExprEval.ofStringArray(this.value);
    }

    @Override
    public String stringify() {
        if (this.value.length == 0) {
            return "<STRING>[]";
        }
        return StringUtils.format("<STRING>[%s]", ARG_JOINER.join(Arrays.stream(this.value).map(s -> s == null ? "null" : StringUtils.format("'%s'", StringEscapeUtils.escapeJavaScript((String)s))).iterator()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringArrayExpr that = (StringArrayExpr)o;
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

