/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.DoubleSumAggregateCombiner;
import org.apache.druid.query.aggregation.FloatSumAggregator;
import org.apache.druid.query.aggregation.FloatSumBufferAggregator;
import org.apache.druid.query.aggregation.FloatSumVectorAggregator;
import org.apache.druid.query.aggregation.SimpleFloatAggregatorFactory;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorValueSelector;

public class FloatSumAggregatorFactory
extends SimpleFloatAggregatorFactory {
    @JsonCreator
    public FloatSumAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="expression") @Nullable String expression, @JacksonInject ExprMacroTable macroTable) {
        super(macroTable, name, fieldName, expression);
    }

    public FloatSumAggregatorFactory(String name, String fieldName) {
        this(name, fieldName, null, ExprMacroTable.nil());
    }

    @Override
    protected float nullValue() {
        return 0.0f;
    }

    @Override
    protected Aggregator buildAggregator(BaseFloatColumnValueSelector selector) {
        return new FloatSumAggregator(selector);
    }

    @Override
    protected BufferAggregator buildBufferAggregator(BaseFloatColumnValueSelector selector) {
        return new FloatSumBufferAggregator(selector);
    }

    @Override
    protected VectorValueSelector vectorSelector(VectorColumnSelectorFactory columnSelectorFactory) {
        return columnSelectorFactory.makeValueSelector(this.fieldName);
    }

    @Override
    public boolean canVectorize(ColumnInspector columnInspector) {
        if (this.fieldName != null) {
            ColumnCapabilities capabilities = columnInspector.getColumnCapabilities(this.fieldName);
            return this.expression == null && (capabilities == null || capabilities.getType().isNumeric());
        }
        return this.expression == null;
    }

    @Override
    protected VectorAggregator factorizeVector(VectorColumnSelectorFactory columnSelectorFactory, VectorValueSelector selector) {
        return new FloatSumVectorAggregator(selector);
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        return FloatSumAggregator.combineValues(lhs, rhs);
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new DoubleSumAggregateCombiner();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new FloatSumAggregatorFactory(this.name, this.name, null, this.macroTable);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new FloatSumAggregatorFactory(this.fieldName, this.fieldName, this.expression, this.macroTable));
    }

    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8WithNullToEmpty((String)this.fieldName);
        byte[] expressionBytes = StringUtils.toUtf8WithNullToEmpty((String)this.expression);
        return ByteBuffer.allocate(2 + fieldNameBytes.length + expressionBytes.length).put((byte)12).put(fieldNameBytes).put((byte)-1).put(expressionBytes).array();
    }

    public String toString() {
        return "FloatSumAggregatorFactory{fieldName='" + this.fieldName + '\'' + ", expression='" + this.expression + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

