/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.search;

import com.google.inject.Inject;
import java.util.concurrent.ExecutorService;
import org.apache.druid.query.ChainedExecutionQueryRunner;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.Result;
import org.apache.druid.query.search.SearchQuery;
import org.apache.druid.query.search.SearchQueryQueryToolChest;
import org.apache.druid.query.search.SearchQueryRunner;
import org.apache.druid.query.search.SearchResultValue;
import org.apache.druid.query.search.SearchStrategySelector;
import org.apache.druid.segment.Segment;

public class SearchQueryRunnerFactory
implements QueryRunnerFactory<Result<SearchResultValue>, SearchQuery> {
    private final SearchStrategySelector strategySelector;
    private final SearchQueryQueryToolChest toolChest;
    private final QueryWatcher queryWatcher;

    @Inject
    public SearchQueryRunnerFactory(SearchStrategySelector strategySelector, SearchQueryQueryToolChest toolChest, QueryWatcher queryWatcher) {
        this.strategySelector = strategySelector;
        this.toolChest = toolChest;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<SearchResultValue>> createRunner(Segment segment) {
        return new SearchQueryRunner(segment, this.strategySelector);
    }

    @Override
    public QueryRunner<Result<SearchResultValue>> mergeRunners(ExecutorService queryExecutor, Iterable<QueryRunner<Result<SearchResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<SearchResultValue>>(queryExecutor, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<SearchResultValue>, SearchQuery> getToolchest() {
        return this.toolChest;
    }
}

