/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.column.SpatialIndex;
import org.apache.druid.segment.column.UnknownTypeComplexColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.selector.settable.SettableColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableObjectColumnValueSelector;

class SimpleColumnHolder
implements ColumnHolder {
    private final ColumnCapabilities capabilities;
    private final Supplier<? extends BaseColumn> columnSupplier;
    @Nullable
    private final Supplier<BitmapIndex> bitmapIndex;
    @Nullable
    private final Supplier<SpatialIndex> spatialIndex;
    private static final InvalidComplexColumnTypeValueSelector INVALID_COMPLEX_COLUMN_TYPE_VALUE_SELECTOR = new InvalidComplexColumnTypeValueSelector();

    SimpleColumnHolder(ColumnCapabilities capabilities, @Nullable Supplier<? extends BaseColumn> columnSupplier, @Nullable Supplier<BitmapIndex> bitmapIndex, @Nullable Supplier<SpatialIndex> spatialIndex) {
        this.capabilities = capabilities;
        this.columnSupplier = columnSupplier;
        if (columnSupplier == null) {
            Preconditions.checkArgument((capabilities.getType() == ValueType.COMPLEX ? 1 : 0) != 0, (Object)"Only complex column types can have nullable column suppliers");
        }
        this.bitmapIndex = bitmapIndex;
        this.spatialIndex = spatialIndex;
    }

    @Override
    public ColumnCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public int getLength() {
        try (NumericColumn column = (NumericColumn)this.columnSupplier.get();){
            int n = column.length();
            return n;
        }
    }

    @Override
    public BaseColumn getColumn() {
        return this.columnSupplier == null ? UnknownTypeComplexColumn.instance() : (BaseColumn)this.columnSupplier.get();
    }

    @Override
    @Nullable
    public BitmapIndex getBitmapIndex() {
        return this.bitmapIndex == null ? null : (BitmapIndex)this.bitmapIndex.get();
    }

    @Override
    @Nullable
    public SpatialIndex getSpatialIndex() {
        return this.spatialIndex == null ? null : (SpatialIndex)this.spatialIndex.get();
    }

    @Override
    public SettableColumnValueSelector makeNewSettableColumnValueSelector() {
        if (this.columnSupplier == null) {
            return INVALID_COMPLEX_COLUMN_TYPE_VALUE_SELECTOR;
        }
        return this.getCapabilities().getType().makeNewSettableColumnValueSelector();
    }

    private static class InvalidComplexColumnTypeValueSelector
    extends SettableObjectColumnValueSelector {
        private InvalidComplexColumnTypeValueSelector() {
        }

        @Override
        public void setValueFrom(ColumnValueSelector selector) {
        }

        @Override
        @Nullable
        public Object getObject() {
            return UnknownTypeComplexColumn.instance().getRowValue(0);
        }
    }
}

