/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.ingestion;

import com.facebook.airlift.json.JsonCodec;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.hadoop.fs.Path;

public class DruidIngestTask {
    public static final String TASK_TYPE_INDEX_PARALLEL = "index_parallel";
    public static final String INPUT_FORMAT_JSON = "json";
    public static final String DEFAULT_INPUT_FILE_FILTER = "*.json.gz";
    private final String type;
    private final DruidIngestSpec spec;

    private DruidIngestTask(String type, DruidIngestSpec spec) {
        this.type = type;
        this.spec = spec;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="spec")
    public DruidIngestSpec getSpec() {
        return this.spec;
    }

    public String toJson() {
        return JsonCodec.jsonCodec(DruidIngestTask.class).toJson((Object)this);
    }

    public static class DruidIngestInputFormat {
        private final String type;

        public DruidIngestInputFormat(String type) {
            this.type = type;
        }

        @JsonProperty(value="type")
        public String getType() {
            return this.type;
        }
    }

    public static class DruidIngestHDFSInput
    implements DruidIngestInputSource {
        private final String type;
        private final List<String> paths;

        public DruidIngestHDFSInput(String type, List<String> paths) {
            this.type = type;
            this.paths = paths;
        }

        @JsonProperty(value="type")
        public String getType() {
            return this.type;
        }

        @JsonProperty(value="paths")
        public List<String> getBaseDir() {
            return this.paths;
        }
    }

    public static class DruidIngestLocalInput
    implements DruidIngestInputSource {
        private final String type;
        private final String baseDir;
        private final String filter;

        public DruidIngestLocalInput(String type, String baseDir, String filter) {
            this.type = type;
            this.baseDir = baseDir;
            this.filter = filter;
        }

        @JsonProperty(value="type")
        public String getType() {
            return this.type;
        }

        @JsonProperty(value="baseDir")
        public String getBaseDir() {
            return this.baseDir;
        }

        @JsonProperty(value="filter")
        public String getFilter() {
            return this.filter;
        }
    }

    public static interface DruidIngestInputSource {
    }

    public static class DruidIngestIOConfig {
        private final String type;
        private final DruidIngestInputSource inputSource;
        private final DruidIngestInputFormat inputFormat;
        private final boolean appendToExisting;

        public DruidIngestIOConfig(String type, DruidIngestInputSource inputSource, DruidIngestInputFormat inputFormat, boolean appendToExisting) {
            this.type = type;
            this.inputSource = inputSource;
            this.inputFormat = inputFormat;
            this.appendToExisting = appendToExisting;
        }

        @JsonProperty(value="type")
        public String getType() {
            return this.type;
        }

        @JsonProperty(value="inputSource")
        public DruidIngestInputSource getInputSource() {
            return this.inputSource;
        }

        @JsonProperty(value="inputFormat")
        public DruidIngestInputFormat getInputFormat() {
            return this.inputFormat;
        }

        @JsonProperty(value="appendToExisting")
        public boolean isAppendToExisting() {
            return this.appendToExisting;
        }
    }

    public static class DruidIngestDimension {
        private final String type;
        private final String name;

        public DruidIngestDimension(String type, String name) {
            this.type = type;
            this.name = name;
        }

        @JsonProperty(value="type")
        public String getType() {
            return this.type;
        }

        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }
    }

    public static class DruidIngestDimensionsSpec {
        private final List<DruidIngestDimension> dimensions;

        public DruidIngestDimensionsSpec(List<DruidIngestDimension> dimensions) {
            this.dimensions = dimensions;
        }

        @JsonProperty(value="dimensions")
        public List<DruidIngestDimension> getDimensions() {
            return this.dimensions;
        }
    }

    public static class DruidIngestTimestampSpec {
        private final String column;

        public DruidIngestTimestampSpec(String column) {
            this.column = column;
        }

        @JsonProperty(value="column")
        public String getColumn() {
            return this.column;
        }
    }

    public static class DruidIngestDataSchema {
        private final String dataSource;
        private final DruidIngestTimestampSpec timestampSpec;
        private final DruidIngestDimensionsSpec dimensionsSpec;

        public DruidIngestDataSchema(String dataSource, DruidIngestTimestampSpec timestampSpec, DruidIngestDimensionsSpec dimensionsSpec) {
            this.dataSource = dataSource;
            this.timestampSpec = timestampSpec;
            this.dimensionsSpec = dimensionsSpec;
        }

        @JsonProperty(value="dataSource")
        public String getDataSource() {
            return this.dataSource;
        }

        @JsonProperty(value="timestampSpec")
        public DruidIngestTimestampSpec getTimestampSpec() {
            return this.timestampSpec;
        }

        @JsonProperty(value="dimensionsSpec")
        public DruidIngestDimensionsSpec getDimensionsSpec() {
            return this.dimensionsSpec;
        }
    }

    public static class DruidIngestSpec {
        private final DruidIngestDataSchema dataSchema;
        private final DruidIngestIOConfig ioConfig;

        public DruidIngestSpec(DruidIngestDataSchema dataSchema, DruidIngestIOConfig ioConfig) {
            this.dataSchema = dataSchema;
            this.ioConfig = ioConfig;
        }

        @JsonProperty(value="dataSchema")
        public DruidIngestDataSchema getDataSchema() {
            return this.dataSchema;
        }

        @JsonProperty(value="ioConfig")
        public DruidIngestIOConfig getIoConfig() {
            return this.ioConfig;
        }
    }

    public static class Builder {
        private String dataSource;
        private String timestampColumn;
        private List<DruidIngestDimension> dimensions;
        private DruidIngestInputSource inputSource;
        private boolean appendToExisting;

        public Builder withDataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder withTimestampColumn(String timestampColumn) {
            this.timestampColumn = timestampColumn;
            return this;
        }

        public Builder withDimensions(List<DruidIngestDimension> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder withInputSource(Path baseDir, List<String> dataFileList) {
            switch (baseDir.toUri().getScheme()) {
                case "file": {
                    this.inputSource = new DruidIngestLocalInput("local", baseDir.toString(), DruidIngestTask.DEFAULT_INPUT_FILE_FILTER);
                    break;
                }
                case "hdfs": {
                    this.inputSource = new DruidIngestHDFSInput("hdfs", dataFileList);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported ingestion input source:" + baseDir.toUri().getScheme());
                }
            }
            return this;
        }

        public Builder withAppendToExisting(boolean appendToExisting) {
            this.appendToExisting = appendToExisting;
            return this;
        }

        public DruidIngestTask build() {
            DruidIngestDataSchema dataSchema = new DruidIngestDataSchema(this.dataSource, new DruidIngestTimestampSpec(this.timestampColumn), new DruidIngestDimensionsSpec(this.dimensions));
            DruidIngestIOConfig ioConfig = new DruidIngestIOConfig(DruidIngestTask.TASK_TYPE_INDEX_PARALLEL, this.inputSource, new DruidIngestInputFormat(DruidIngestTask.INPUT_FORMAT_JSON), this.appendToExisting);
            DruidIngestSpec spec = new DruidIngestSpec(dataSchema, ioConfig);
            return new DruidIngestTask(DruidIngestTask.TASK_TYPE_INDEX_PARALLEL, spec);
        }
    }
}

