/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.ingestion;

import com.facebook.presto.druid.DruidClient;
import com.facebook.presto.druid.DruidConfig;
import com.facebook.presto.druid.ingestion.DruidIngestionTableHandle;
import com.facebook.presto.druid.ingestion.DruidPageSink;
import com.facebook.presto.druid.ingestion.DruidPageWriter;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PageSinkContext;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;
import javax.inject.Inject;

public class DruidPageSinkProvider
implements ConnectorPageSinkProvider {
    private final DruidConfig druidConfig;
    private final DruidClient druidClient;
    private final DruidPageWriter druidPageWriter;

    @Inject
    public DruidPageSinkProvider(DruidConfig druidConfig, DruidClient druidClient, DruidPageWriter druidPageWriter) {
        this.druidConfig = Objects.requireNonNull(druidConfig, "druid config is null");
        this.druidClient = Objects.requireNonNull(druidClient, "druid client is null");
        this.druidPageWriter = Objects.requireNonNull(druidPageWriter, "page writer is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, PageSinkContext pageSinkContext) {
        DruidIngestionTableHandle tableHandle = (DruidIngestionTableHandle)outputTableHandle;
        return new DruidPageSink(this.druidConfig, this.druidClient, tableHandle, this.druidPageWriter);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, PageSinkContext pageSinkContext) {
        DruidIngestionTableHandle tableHandle = (DruidIngestionTableHandle)insertTableHandle;
        return new DruidPageSink(this.druidConfig, this.druidClient, tableHandle, this.druidPageWriter);
    }
}

