/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.segment;

import com.facebook.presto.druid.DataInputSource;
import com.facebook.presto.druid.DataInputSourceId;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.fs.FSDataInputStream;

public class HdfsDataInputSource
implements DataInputSource {
    private final DataInputSourceId id;
    private final FSDataInputStream inputStream;
    private final long size;
    private long readTimeNanos;

    public HdfsDataInputSource(DataInputSourceId id, FSDataInputStream inputStream, long size) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.inputStream = Objects.requireNonNull(inputStream, "inputStream is null");
        this.size = size;
    }

    @Override
    public DataInputSourceId getId() {
        return this.id;
    }

    @Override
    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void readFully(long position, byte[] buffer) {
        this.readFully(position, buffer, 0, buffer.length);
    }

    @Override
    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) {
        long start = System.nanoTime();
        this.readInternal(position, buffer, bufferOffset, bufferLength);
        this.readTimeNanos += System.nanoTime() - start;
    }

    private void readInternal(long position, byte[] buffer, int bufferOffset, int bufferLength) {
        try {
            this.inputStream.readFully(position, buffer, bufferOffset, bufferLength);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_DEEP_STORAGE_ERROR, String.format("Error reading from %s at position %s", this.id, position), (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

