/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.joda.time.DateTime;

public class GroupByQueryHelper {
    public static final String CTX_KEY_SORT_RESULTS = "sortResults";

    public static <T> Pair<IncrementalIndex, Accumulator<IncrementalIndex, T>> createIndexAccumulatorPair(final GroupByQuery query, final @Nullable GroupByQuery subquery, GroupByQueryConfig config, NonBlockingPool<ByteBuffer> bufferPool) {
        GroupByQueryConfig querySpecificConfig = config.withOverrides(query);
        Granularity gran = query.getGranularity();
        DateTime timeStart = query.getIntervals().get(0).getStart();
        final boolean combine = subquery == null;
        DateTime granTimeStart = timeStart;
        if (!Granularities.ALL.equals(gran)) {
            granTimeStart = gran.bucketStart(timeStart);
        }
        List aggs = combine ? Lists.transform(query.getAggregatorSpecs(), (Function)new Function<AggregatorFactory, AggregatorFactory>(){

            public AggregatorFactory apply(AggregatorFactory input) {
                return input.getCombiningFactory();
            }
        }) : query.getAggregatorSpecs();
        final List dimensions = Lists.transform(query.getDimensions(), (Function)new Function<DimensionSpec, String>(){

            public String apply(DimensionSpec input) {
                return input.getOutputName();
            }
        });
        boolean sortResults = query.getContextValue(CTX_KEY_SORT_RESULTS, true);
        ArrayList<StringDimensionSchema> dimensionSchemas = new ArrayList<StringDimensionSchema>();
        for (DimensionSpec dimension : query.getDimensions()) {
            dimensionSchemas.add(new StringDimensionSchema(dimension.getOutputName()));
        }
        IncrementalIndexSchema indexSchema = new IncrementalIndexSchema.Builder().withDimensionsSpec(new DimensionsSpec(dimensionSchemas, null, null)).withMetrics(aggs.toArray(new AggregatorFactory[0])).withQueryGranularity(gran).withMinTimestamp(granTimeStart.getMillis()).build();
        IncrementalIndex index = query.getContextValue("useOffheap", false) != false ? new IncrementalIndex.Builder().setIndexSchema(indexSchema).setDeserializeComplexMetrics(false).setConcurrentEventAdd(true).setSortFacts(sortResults).setMaxRowCount(querySpecificConfig.getMaxResults()).buildOffheap(bufferPool) : new IncrementalIndex.Builder().setIndexSchema(indexSchema).setDeserializeComplexMetrics(false).setConcurrentEventAdd(true).setSortFacts(sortResults).setMaxRowCount(querySpecificConfig.getMaxResults()).buildOnheap();
        Accumulator accumulator = new Accumulator<IncrementalIndex, T>(){

            public IncrementalIndex accumulate(IncrementalIndex accumulated, T in) {
                MapBasedRow mapBasedRow;
                if (in instanceof MapBasedRow) {
                    mapBasedRow = (MapBasedRow)in;
                } else if (in instanceof ResultRow) {
                    ResultRow row = (ResultRow)in;
                    mapBasedRow = row.toMapBasedRow(combine ? query : subquery);
                } else {
                    throw new ISE("Unable to accumulate something of type [%s]", new Object[]{in.getClass()});
                }
                try {
                    accumulated.add((InputRow)new MapBasedInputRow(mapBasedRow.getTimestamp(), dimensions, mapBasedRow.getEvent()));
                }
                catch (IndexSizeExceededException e) {
                    throw new ResourceLimitExceededException(e.getMessage(), new Object[0]);
                }
                return accumulated;
            }
        };
        return new Pair((Object)index, (Object)accumulator);
    }

    public static <T> Pair<Queue, Accumulator<Queue, T>> createBySegmentAccumulatorPair() {
        ConcurrentLinkedQueue init = new ConcurrentLinkedQueue();
        Accumulator accumulator = new Accumulator<Queue, T>(){

            public Queue accumulate(Queue accumulated, T in) {
                if (in == null) {
                    throw new ISE("Cannot have null result", new Object[0]);
                }
                accumulated.offer(in);
                return accumulated;
            }
        };
        return new Pair(init, (Object)accumulator);
    }

    public static IncrementalIndex makeIncrementalIndex(GroupByQuery query, @Nullable GroupByQuery subquery, GroupByQueryConfig config, NonBlockingPool<ByteBuffer> bufferPool, Sequence<ResultRow> rows) {
        Pair indexAccumulatorPair = GroupByQueryHelper.createIndexAccumulatorPair(query, subquery, config, bufferPool);
        return (IncrementalIndex)rows.accumulate(indexAccumulatorPair.lhs, (Accumulator)indexAccumulatorPair.rhs);
    }

    public static Sequence<ResultRow> postAggregate(GroupByQuery query, IncrementalIndex<?> index) {
        return Sequences.map((Sequence)Sequences.simple(index.iterableWithPostAggregations(query.getPostAggregatorSpecs(), query.isDescending())), input -> {
            ResultRow resultRow = GroupByQueryHelper.toResultRow(query, input);
            if (query.getResultRowHasTimestamp()) {
                resultRow.set(0, query.getGranularity().toDateTime(resultRow.getLong(0)).getMillis());
            }
            return resultRow;
        });
    }

    public static ResultRow toResultRow(GroupByQuery query, Row row) {
        ResultRow resultRow = ResultRow.create(query.getResultRowSizeWithPostAggregators());
        int i = 0;
        if (query.getResultRowHasTimestamp()) {
            resultRow.set(i++, row.getTimestampFromEpoch());
        }
        for (DimensionSpec dimensionSpec : query.getDimensions()) {
            resultRow.set(i++, row.getRaw(dimensionSpec.getOutputName()));
        }
        for (AggregatorFactory aggregatorFactory : query.getAggregatorSpecs()) {
            resultRow.set(i++, row.getRaw(aggregatorFactory.getName()));
        }
        for (PostAggregator postAggregator : query.getPostAggregatorSpecs()) {
            resultRow.set(i++, row.getRaw(postAggregator.getName()));
        }
        return resultRow;
    }
}

