/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.Groupers;
import org.apache.druid.query.groupby.epinephelinae.IntGrouper;
import org.apache.druid.query.groupby.epinephelinae.VectorGrouper;

public class BufferArrayGrouper
implements VectorGrouper,
IntGrouper {
    private final Supplier<ByteBuffer> bufferSupplier;
    private final AggregatorAdapters aggregators;
    private final int cardinalityWithMissingValue;
    private final int recordSize;
    private boolean initialized = false;
    private WritableMemory usedFlagMemory;
    private ByteBuffer valBuffer;
    @Nullable
    private int[] vAggregationPositions = null;
    @Nullable
    private int[] vAggregationRows = null;

    static long requiredBufferCapacity(int cardinality, AggregatorFactory[] aggregatorFactories) {
        long cardinalityWithMissingValue = BufferArrayGrouper.computeCardinalityWithMissingValue(cardinality);
        if (cardinalityWithMissingValue > Integer.MAX_VALUE) {
            return -1L;
        }
        long recordSize = Arrays.stream(aggregatorFactories).mapToLong(AggregatorFactory::getMaxIntermediateSizeWithNulls).sum();
        return BufferArrayGrouper.getUsedFlagBufferCapacity(cardinalityWithMissingValue) + cardinalityWithMissingValue * recordSize;
    }

    private static long computeCardinalityWithMissingValue(int cardinality) {
        return (long)cardinality + 1L;
    }

    private static long getUsedFlagBufferCapacity(long cardinalityWithMissingValue) {
        return (cardinalityWithMissingValue + 8L - 1L) / 8L;
    }

    public BufferArrayGrouper(Supplier<ByteBuffer> bufferSupplier, AggregatorAdapters aggregators, int cardinality) {
        Preconditions.checkNotNull((Object)aggregators, (Object)"aggregators");
        Preconditions.checkArgument((cardinality > 0 ? 1 : 0) != 0, (Object)"Cardinality must a non-zero positive number");
        this.bufferSupplier = (Supplier)Preconditions.checkNotNull(bufferSupplier, (Object)"bufferSupplier");
        this.aggregators = aggregators;
        this.cardinalityWithMissingValue = Ints.checkedCast((long)BufferArrayGrouper.computeCardinalityWithMissingValue(cardinality));
        this.recordSize = aggregators.spaceNeeded();
    }

    @Override
    public void init() {
        if (!this.initialized) {
            ByteBuffer buffer = (ByteBuffer)this.bufferSupplier.get();
            int usedFlagBufferEnd = Ints.checkedCast((long)BufferArrayGrouper.getUsedFlagBufferCapacity(this.cardinalityWithMissingValue));
            if ((long)usedFlagBufferEnd + (long)this.cardinalityWithMissingValue * (long)this.recordSize > (long)buffer.capacity()) {
                throw new ISE("Records of size[%,d] and possible cardinality[%,d] exceeds the buffer capacity[%,d].", new Object[]{this.recordSize, this.cardinalityWithMissingValue, this.valBuffer.capacity()});
            }
            buffer.position(0);
            buffer.limit(usedFlagBufferEnd);
            this.usedFlagMemory = WritableMemory.wrap((ByteBuffer)buffer.slice(), (ByteOrder)ByteOrder.nativeOrder());
            buffer.position(usedFlagBufferEnd);
            buffer.limit(buffer.capacity());
            this.valBuffer = buffer.slice();
            this.reset();
            this.initialized = true;
        }
    }

    @Override
    public void initVectorized(int maxVectorSize) {
        this.init();
        this.vAggregationPositions = new int[maxVectorSize];
        this.vAggregationRows = new int[maxVectorSize];
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public AggregateResult aggregateKeyHash(int dimIndex) {
        Preconditions.checkArgument((dimIndex >= 0 && dimIndex < this.cardinalityWithMissingValue ? 1 : 0) != 0, (String)"Invalid dimIndex[%s]", (Object[])new Object[]{dimIndex});
        this.initializeSlotIfNeeded(dimIndex);
        this.aggregators.aggregateBuffered(this.valBuffer, dimIndex * this.recordSize);
        return AggregateResult.ok();
    }

    @Override
    public AggregateResult aggregateVector(Memory keySpace, int startRow, int endRow) {
        int numRows = endRow - startRow;
        if (keySpace.getCapacity() < (long)numRows * 4L) {
            throw new IAE("Not enough keySpace capacity for the provided start/end rows", new Object[0]);
        }
        if (keySpace.getCapacity() > Integer.MAX_VALUE) {
            throw new ISE("keySpace too large to handle", new Object[0]);
        }
        if (this.vAggregationPositions == null || this.vAggregationRows == null) {
            throw new ISE("Grouper was not initialized for vectorization", new Object[0]);
        }
        if (keySpace.getCapacity() == 0L) {
            boolean dimIndex = true;
            this.initializeSlotIfNeeded(1);
            this.aggregators.aggregateVector(this.valBuffer, 1 * this.recordSize, startRow, endRow);
        } else {
            for (int i = 0; i < numRows; ++i) {
                int dimIndex = keySpace.getInt((long)i * 4L) + 1;
                if (dimIndex < 0 || dimIndex >= this.cardinalityWithMissingValue) {
                    throw new IAE("Invalid dimIndex[%s]", new Object[]{dimIndex});
                }
                this.vAggregationPositions[i] = dimIndex * this.recordSize;
                this.initializeSlotIfNeeded(dimIndex);
            }
            this.aggregators.aggregateVector(this.valBuffer, numRows, this.vAggregationPositions, Groupers.writeAggregationRows(this.vAggregationRows, startRow, endRow));
        }
        return AggregateResult.ok();
    }

    private void initializeSlotIfNeeded(int dimIndex) {
        int index = dimIndex / 8;
        int extraIndex = dimIndex % 8;
        int usedFlagMask = 1 << extraIndex;
        byte currentByte = this.usedFlagMemory.getByte((long)index);
        if ((currentByte & usedFlagMask) == 0) {
            this.usedFlagMemory.putByte((long)index, (byte)(currentByte | usedFlagMask));
            this.aggregators.init(this.valBuffer, dimIndex * this.recordSize);
        }
    }

    private boolean isUsedSlot(int dimIndex) {
        int index = dimIndex / 8;
        int extraIndex = dimIndex % 8;
        int usedFlagMask = 1 << extraIndex;
        return (this.usedFlagMemory.getByte((long)index) & usedFlagMask) != 0;
    }

    @Override
    public void reset() {
        this.usedFlagMemory.clear();
    }

    @Override
    public IntGrouper.IntGrouperHashFunction hashFunction() {
        return key -> key + 1;
    }

    @Override
    public void close() {
        this.aggregators.close();
    }

    @Override
    public CloseableIterator<Grouper.Entry<Memory>> iterator() {
        final CloseableIterator<Grouper.Entry<Integer>> iterator = this.iterator(false);
        final WritableMemory keyMemory = WritableMemory.allocate((int)4);
        return new CloseableIterator<Grouper.Entry<Memory>>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Grouper.Entry<Memory> next() {
                Grouper.Entry integerEntry = (Grouper.Entry)iterator.next();
                keyMemory.putInt(0L, ((Integer)integerEntry.getKey()).intValue());
                return new Grouper.Entry<WritableMemory>(keyMemory, integerEntry.getValues());
            }

            public void close() throws IOException {
                iterator.close();
            }
        };
    }

    @Override
    public CloseableIterator<Grouper.Entry<Integer>> iterator(boolean sorted) {
        if (sorted) {
            throw new UnsupportedOperationException("sorted iterator is not supported yet");
        }
        return new CloseableIterator<Grouper.Entry<Integer>>(){
            private int next = this.findNext(-1);

            public boolean hasNext() {
                return this.next >= 0;
            }

            public Grouper.Entry<Integer> next() {
                if (this.next < 0) {
                    throw new NoSuchElementException();
                }
                int current = this.next;
                this.next = this.findNext(current);
                Object[] values = new Object[BufferArrayGrouper.this.aggregators.size()];
                int recordOffset = current * BufferArrayGrouper.this.recordSize;
                for (int i = 0; i < BufferArrayGrouper.this.aggregators.size(); ++i) {
                    values[i] = BufferArrayGrouper.this.aggregators.get(BufferArrayGrouper.this.valBuffer, recordOffset, i);
                }
                return new Grouper.Entry<Integer>(current - 1, values);
            }

            public void close() {
            }

            private int findNext(int current) {
                for (int i = current + 1; i < BufferArrayGrouper.this.cardinalityWithMissingValue; ++i) {
                    if (!BufferArrayGrouper.this.isUsedSlot(i)) continue;
                    return i;
                }
                return -1;
            }
        };
    }
}

