/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.metadata.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

public class ColumnAnalysis {
    private static final String ERROR_PREFIX = "error:";
    private final String type;
    private final boolean hasMultipleValues;
    private final long size;
    private final Integer cardinality;
    private final Comparable minValue;
    private final Comparable maxValue;
    private final String errorMessage;

    public static ColumnAnalysis error(String reason) {
        return new ColumnAnalysis("STRING", false, -1L, null, null, null, ERROR_PREFIX + reason);
    }

    @JsonCreator
    public ColumnAnalysis(@JsonProperty(value="type") String type, @JsonProperty(value="hasMultipleValues") boolean hasMultipleValues, @JsonProperty(value="size") long size, @JsonProperty(value="cardinality") Integer cardinality, @JsonProperty(value="minValue") Comparable minValue, @JsonProperty(value="maxValue") Comparable maxValue, @JsonProperty(value="errorMessage") String errorMessage) {
        this.type = type;
        this.hasMultipleValues = hasMultipleValues;
        this.size = size;
        this.cardinality = cardinality;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.errorMessage = errorMessage;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public boolean isHasMultipleValues() {
        return this.hasMultipleValues;
    }

    @JsonProperty
    public long getSize() {
        return this.size;
    }

    @JsonProperty
    public Integer getCardinality() {
        return this.cardinality;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
    @JsonProperty
    public Comparable getMinValue() {
        return this.minValue;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
    @JsonProperty
    public Comparable getMaxValue() {
        return this.maxValue;
    }

    @JsonProperty
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isError() {
        return this.errorMessage != null && !this.errorMessage.isEmpty();
    }

    public ColumnAnalysis fold(ColumnAnalysis rhs) {
        if (rhs == null) {
            return this;
        }
        if (this.isError() && rhs.isError()) {
            return this.errorMessage.equals(rhs.getErrorMessage()) ? this : ColumnAnalysis.error("multiple_errors");
        }
        if (this.isError()) {
            return this;
        }
        if (rhs.isError()) {
            return rhs;
        }
        if (!this.type.equals(rhs.getType())) {
            return ColumnAnalysis.error("cannot_merge_diff_types");
        }
        Integer cardinality = this.getCardinality();
        Integer rhsCardinality = rhs.getCardinality();
        if (cardinality == null) {
            cardinality = rhsCardinality;
        } else if (rhsCardinality != null) {
            cardinality = Math.max(cardinality, rhsCardinality);
        }
        boolean multipleValues = this.hasMultipleValues || rhs.isHasMultipleValues();
        Comparable newMin = this.choose(this.minValue, rhs.minValue, false);
        Comparable newMax = this.choose(this.maxValue, rhs.maxValue, true);
        return new ColumnAnalysis(this.type, multipleValues, this.size + rhs.getSize(), cardinality, newMin, newMax, null);
    }

    private <T extends Comparable> T choose(T obj1, T obj2, boolean max) {
        if (obj1 == null) {
            return (T)(max ? obj2 : null);
        }
        if (obj2 == null) {
            return (T)(max ? obj1 : null);
        }
        int compare = max ? obj1.compareTo(obj2) : obj2.compareTo(obj1);
        return compare > 0 ? obj1 : obj2;
    }

    public String toString() {
        return "ColumnAnalysis{type='" + this.type + '\'' + ", hasMultipleValues=" + this.hasMultipleValues + ", size=" + this.size + ", cardinality=" + this.cardinality + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnAnalysis that = (ColumnAnalysis)o;
        return this.hasMultipleValues == that.hasMultipleValues && this.size == that.size && Objects.equals(this.type, that.type) && Objects.equals(this.cardinality, that.cardinality) && Objects.equals(this.minValue, that.minValue) && Objects.equals(this.maxValue, that.maxValue) && Objects.equals(this.errorMessage, that.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.hasMultipleValues, this.size, this.cardinality, this.minValue, this.maxValue, this.errorMessage);
    }
}

