/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.parsers.ParseException;

public class InputRowListPlusRawValues {
    @Nullable
    private final List<InputRow> inputRows;
    @Nullable
    private final Map<String, Object> rawValues;
    @Nullable
    private final ParseException parseException;

    public static InputRowListPlusRawValues of(@Nullable InputRow inputRow, Map<String, Object> rawColumns) {
        return InputRowListPlusRawValues.of(inputRow == null ? null : Collections.singletonList(inputRow), rawColumns);
    }

    public static InputRowListPlusRawValues of(@Nullable List<InputRow> inputRows, Map<String, Object> rawColumns) {
        return new InputRowListPlusRawValues(inputRows, (Map)Preconditions.checkNotNull(rawColumns, (Object)"rawColumns"), null);
    }

    public static InputRowListPlusRawValues of(@Nullable Map<String, Object> rawColumns, ParseException parseException) {
        return new InputRowListPlusRawValues(null, rawColumns, (ParseException)Preconditions.checkNotNull((Object)parseException, (Object)"parseException"));
    }

    private InputRowListPlusRawValues(@Nullable List<InputRow> inputRows, @Nullable Map<String, Object> rawValues, @Nullable ParseException parseException) {
        this.inputRows = inputRows;
        this.rawValues = rawValues;
        this.parseException = parseException;
    }

    @Nullable
    public List<InputRow> getInputRows() {
        return this.inputRows;
    }

    @Nullable
    public Map<String, Object> getRawValues() {
        return this.rawValues;
    }

    @Nullable
    public ParseException getParseException() {
        return this.parseException;
    }
}

