/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.ConcatSequence;
import org.apache.druid.java.util.common.guava.ExecuteWhenDoneYielder;
import org.apache.druid.java.util.common.guava.FilteredSequence;
import org.apache.druid.java.util.common.guava.MappedSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.SequenceWrapper;
import org.apache.druid.java.util.common.guava.WrappingSequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.java.util.common.guava.YieldingSequenceBase;

public class Sequences {
    private static final EmptySequence EMPTY_SEQUENCE = new EmptySequence();

    public static <T> Sequence<T> simple(final Iterable<T> iterable) {
        return new BaseSequence(new BaseSequence.IteratorMaker<T, Iterator<T>>(){

            @Override
            public Iterator<T> make() {
                return iterable.iterator();
            }

            @Override
            public void cleanup(Iterator<T> iterFromMake) {
            }
        });
    }

    public static <T> Sequence<T> empty() {
        return EMPTY_SEQUENCE;
    }

    public static <T> Sequence<T> concat(Sequence<T> ... sequences) {
        return Sequences.concat(Arrays.asList(sequences));
    }

    public static <T> Sequence<T> concat(Iterable<Sequence<T>> sequences) {
        return Sequences.concat(Sequences.simple(sequences));
    }

    public static <T> Sequence<T> concat(Sequence<? extends Sequence<T>> sequences) {
        return new ConcatSequence(sequences);
    }

    public static <From, To> Sequence<To> map(Sequence<From> sequence, Function<? super From, ? extends To> fn) {
        return new MappedSequence<Object, Object>(sequence, arg_0 -> fn.apply(arg_0));
    }

    public static <T> Sequence<T> filter(Sequence<T> sequence, Predicate<? super T> pred) {
        return new FilteredSequence<T>(sequence, pred);
    }

    public static <T> Sequence<T> withBaggage(Sequence<T> seq, final Closeable baggage) {
        Preconditions.checkNotNull((Object)baggage, (Object)"baggage");
        return Sequences.wrap(seq, new SequenceWrapper(){

            @Override
            public void after(boolean isDone, Throwable thrown) throws Exception {
                baggage.close();
            }
        });
    }

    public static <T> Sequence<T> wrap(Sequence<T> seq, SequenceWrapper wrapper) {
        Preconditions.checkNotNull(seq, (Object)"seq");
        Preconditions.checkNotNull((Object)wrapper, (Object)"wrapper");
        return new WrappingSequence<T>(seq, wrapper);
    }

    public static <T> Sequence<T> withEffect(final Sequence<T> seq, final Runnable effect, final Executor exec) {
        return new YieldingSequenceBase<T>(){

            @Override
            public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                return new ExecuteWhenDoneYielder<OutType>(seq.toYielder(initValue, accumulator), effect, exec);
            }
        };
    }

    public static <T> Sequence<T> sort(Sequence<T> sequence, Comparator<T> comparator) {
        List<T> seqList = sequence.toList();
        Collections.sort(seqList, comparator);
        return Sequences.simple(seqList);
    }

    private static class EmptySequence
    implements Sequence<Object> {
        private EmptySequence() {
        }

        @Override
        public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, Object> accumulator) {
            return initValue;
        }

        @Override
        public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, Object> accumulator) {
            return Yielders.done(initValue, null);
        }
    }
}

