/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;

class IdentifierExpr
implements Expr {
    private final String identifier;
    private final String binding;

    IdentifierExpr(String value) {
        this.identifier = value;
        this.binding = value;
    }

    IdentifierExpr(String identifier, String binding) {
        this.identifier = identifier;
        this.binding = binding;
    }

    public String toString() {
        return this.binding;
    }

    @Nullable
    public String getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public String getBinding() {
        return this.binding;
    }

    @Override
    @Nullable
    public String getIdentifierIfIdentifier() {
        return this.identifier;
    }

    @Override
    @Nullable
    public String getBindingIfIdentifier() {
        return this.binding;
    }

    @Override
    @Nullable
    public IdentifierExpr getIdentifierExprIfIdentifierExpr() {
        return this;
    }

    @Override
    public Expr.BindingDetails analyzeInputs() {
        return new Expr.BindingDetails(this);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return ExprEval.bestEffortOf(bindings.get(this.binding));
    }

    @Override
    public String stringify() {
        return StringUtils.format("\"%s\"", StringEscapeUtils.escapeJava((String)this.binding));
    }

    @Override
    public void visit(Expr.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expr visit(Expr.Shuttle shuttle) {
        return shuttle.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentifierExpr that = (IdentifierExpr)o;
        return Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }
}

