/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ConstantExpr;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;

class StringExpr
extends ConstantExpr {
    @Nullable
    private final String value;

    StringExpr(@Nullable String value) {
        this.value = NullHandling.emptyToNullIfNeeded(value);
    }

    @Override
    @Nullable
    public Object getLiteralValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return ExprEval.of(this.value);
    }

    @Override
    public String stringify() {
        return this.value == null ? "null" : StringUtils.format("'%s'", StringEscapeUtils.escapeJavaScript((String)this.value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringExpr that = (StringExpr)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

