/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.bytecode.expression;

import com.facebook.airlift.bytecode.ArrayOpCode;
import com.facebook.airlift.bytecode.BytecodeBlock;
import com.facebook.airlift.bytecode.BytecodeNode;
import com.facebook.airlift.bytecode.MethodGenerationContext;
import com.facebook.airlift.bytecode.ParameterizedType;
import com.facebook.airlift.bytecode.expression.BytecodeExpression;
import com.facebook.airlift.bytecode.instruction.InstructionNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

class SetArrayElementBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression instance;
    private final BytecodeExpression index;
    private final BytecodeExpression value;
    private final InstructionNode arrayStoreInstruction;

    public SetArrayElementBytecodeExpression(BytecodeExpression instance, BytecodeExpression index, BytecodeExpression value) {
        super(ParameterizedType.type(Void.TYPE));
        this.instance = Objects.requireNonNull(instance, "instance is null");
        this.index = Objects.requireNonNull(index, "index is null");
        this.value = Objects.requireNonNull(value, "value is null");
        ParameterizedType componentType = instance.getType().getArrayComponentType();
        Preconditions.checkArgument((index.getType().getPrimitiveType() == Integer.TYPE ? 1 : 0) != 0, (Object)("index must be int type, but is " + index.getType()));
        Preconditions.checkArgument((boolean)componentType.equals(value.getType()), (String)"value must be %s type, but is %s", (Object)componentType, (Object)value.getType());
        this.arrayStoreInstruction = ArrayOpCode.getArrayOpCode(componentType).getStore();
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return new BytecodeBlock().append(this.instance.getBytecode(generationContext)).append(this.index).append(this.value).append(this.arrayStoreInstruction);
    }

    @Override
    protected String formatOneLine() {
        return this.instance + "[" + this.index + "] = " + this.value;
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.index, (Object)this.value);
    }
}

