/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject.stringtemplate;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.concurrent.GuardedBy;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;
import org.skife.jdbi.v2.sqlobject.stringtemplate.StringTemplate3StatementLocator;

@SqlStatementCustomizingAnnotation(value=LocatorFactory.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface UseStringTemplate3StatementLocator {
    public static final String DEFAULT_VALUE = " ~ ";

    public String value() default " ~ ";

    public Class errorListener() default StringTemplateErrorListener.class;

    public boolean cacheable() default true;

    public static class LocatorFactory
    implements SqlStatementCustomizerFactory {
        @GuardedBy(value="LocatorFactory.class")
        private static final Map<Class<?>, WeakHashMap<Annotation, SqlStatementCustomizer>> CUSTOMIZER_CACHE = new WeakHashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            UseStringTemplate3StatementLocator a = (UseStringTemplate3StatementLocator)annotation;
            if (a.cacheable()) {
                SqlStatementCustomizer cachedCustomizer;
                Class<LocatorFactory> clazz = LocatorFactory.class;
                // MONITORENTER : org.skife.jdbi.v2.sqlobject.stringtemplate.UseStringTemplate3StatementLocator$LocatorFactory.class
                WeakHashMap<Annotation, SqlStatementCustomizer> classCache = CUSTOMIZER_CACHE.get(sqlObjectType);
                if (classCache == null) {
                    classCache = new WeakHashMap();
                    CUSTOMIZER_CACHE.put(sqlObjectType, classCache);
                }
                if ((cachedCustomizer = classCache.get(a)) != null) {
                    // MONITOREXIT : clazz
                    return cachedCustomizer;
                }
                // MONITOREXIT : clazz
            }
            StringTemplate3StatementLocator.Builder builder = UseStringTemplate3StatementLocator.DEFAULT_VALUE.equals(a.value()) ? StringTemplate3StatementLocator.builder(sqlObjectType) : StringTemplate3StatementLocator.builder(a.value());
            StringTemplateErrorListener errorListener = StringTemplateGroup.DEFAULT_ERROR_LISTENER;
            if (!StringTemplateErrorListener.class.equals((Object)a.errorListener())) {
                try {
                    errorListener = (StringTemplateErrorListener)a.errorListener().newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error initializing StringTemplateErrorListener", e);
                }
            }
            final StringTemplate3StatementLocator l = builder.allowImplicitTemplateGroup().treatLiteralsAsTemplates().shouldCache().withErrorListener(errorListener).build();
            SqlStatementCustomizer result = new SqlStatementCustomizer(){

                @Override
                public void apply(SQLStatement q) {
                    q.setStatementLocator(l);
                }
            };
            if (!a.cacheable()) return result;
            Class<LocatorFactory> clazz = LocatorFactory.class;
            // MONITORENTER : org.skife.jdbi.v2.sqlobject.stringtemplate.UseStringTemplate3StatementLocator$LocatorFactory.class
            CUSTOMIZER_CACHE.get(sqlObjectType).put(a, result);
            // MONITOREXIT : clazz
            return result;
        }

        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            throw new UnsupportedOperationException("Not Defined on Method");
        }

        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Object arg) {
            throw new UnsupportedOperationException("Not defined on parameter");
        }
    }
}

