/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.hll;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import org.apache.druid.java.util.common.StringUtils;

public class HyperLogLogHash {
    private static final HyperLogLogHash DEFAULT = new HyperLogLogHash(Hashing.murmur3_128());
    private final HashFunction hashFunction;

    public static HyperLogLogHash getDefault() {
        return DEFAULT;
    }

    public HyperLogLogHash(HashFunction hashFunction) {
        this.hashFunction = hashFunction;
    }

    public byte[] hash(byte[] rawValue) {
        return this.hashFunction.hashBytes(rawValue).asBytes();
    }

    public byte[] hash(String rawValue) {
        return this.hash(StringUtils.toUtf8((String)rawValue));
    }
}

