/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Family;
import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.SketchesReadOnlyException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.MemoryHashIterator;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.UpdateReturnState;
import org.apache.datasketches.theta.UpdateSketch;

class DirectQuickSelectSketchR
extends UpdateSketch {
    static final double DQS_RESIZE_THRESHOLD = 0.9375;
    final long seed_;
    int hashTableThreshold_;
    WritableMemory mem_;

    DirectQuickSelectSketchR(long seed, WritableMemory wmem) {
        this.seed_ = seed;
        this.mem_ = wmem;
    }

    static DirectQuickSelectSketchR readOnlyWrap(Memory srcMem, long seed) {
        int preambleLongs = PreambleUtil.extractPreLongs(srcMem);
        int lgNomLongs = PreambleUtil.extractLgNomLongs(srcMem);
        int lgArrLongs = PreambleUtil.extractLgArrLongs(srcMem);
        UpdateSketch.checkUnionQuickSelectFamily(srcMem, preambleLongs, lgNomLongs);
        DirectQuickSelectSketchR.checkMemIntegrity(srcMem, seed, preambleLongs, lgNomLongs, lgArrLongs);
        DirectQuickSelectSketchR dqssr = new DirectQuickSelectSketchR(seed, (WritableMemory)srcMem);
        dqssr.hashTableThreshold_ = DirectQuickSelectSketchR.setHashTableThreshold(lgNomLongs, lgArrLongs);
        return dqssr;
    }

    static DirectQuickSelectSketchR fastReadOnlyWrap(Memory srcMem, long seed) {
        int lgNomLongs = srcMem.getByte(3L) & 0xFF;
        int lgArrLongs = srcMem.getByte(4L) & 0xFF;
        DirectQuickSelectSketchR dqss = new DirectQuickSelectSketchR(seed, (WritableMemory)srcMem);
        dqss.hashTableThreshold_ = DirectQuickSelectSketchR.setHashTableThreshold(lgNomLongs, lgArrLongs);
        return dqss;
    }

    @Override
    public int getCurrentBytes(boolean compact) {
        if (!compact) {
            byte lgArrLongs = this.mem_.getByte(4L);
            int preambleLongs = this.mem_.getByte(0L) & 0x3F;
            int lengthBytes = preambleLongs + (1 << lgArrLongs) << 3;
            return lengthBytes;
        }
        int preLongs = this.getCurrentPreambleLongs(true);
        int curCount = this.getRetainedEntries(true);
        return preLongs + curCount << 3;
    }

    @Override
    public double getEstimate() {
        int curCount = PreambleUtil.extractCurCount((Memory)this.mem_);
        long thetaLong = PreambleUtil.extractThetaLong((Memory)this.mem_);
        return Sketch.estimate(thetaLong, curCount);
    }

    @Override
    public Family getFamily() {
        int familyID = this.mem_.getByte(2L) & 0xFF;
        return Family.idToFamily(familyID);
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return this.mem_.getInt(8L);
    }

    @Override
    public long getThetaLong() {
        return this.mem_.getLong(16L);
    }

    @Override
    public boolean hasMemory() {
        return true;
    }

    @Override
    public boolean isDirect() {
        return this.mem_.isDirect();
    }

    @Override
    public boolean isEmpty() {
        return PreambleUtil.isEmpty((Memory)this.mem_);
    }

    @Override
    public boolean isSameResource(Memory that) {
        return this.mem_.isSameResource((Object)that);
    }

    @Override
    public HashIterator iterator() {
        return new MemoryHashIterator((Memory)this.mem_, 1 << this.getLgArrLongs(), this.getThetaLong());
    }

    @Override
    public byte[] toByteArray() {
        byte lgArrLongs = this.mem_.getByte(4L);
        int preambleLongs = this.mem_.getByte(0L) & 0x3F;
        int lengthBytes = preambleLongs + (1 << lgArrLongs) << 3;
        byte[] byteArray = new byte[lengthBytes];
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        this.mem_.copyTo(0L, mem, 0L, (long)lengthBytes);
        return byteArray;
    }

    @Override
    public int getLgNomLongs() {
        return PreambleUtil.extractLgNomLongs((Memory)this.mem_);
    }

    @Override
    public ResizeFactor getResizeFactor() {
        return ResizeFactor.getRF(this.getLgRF());
    }

    @Override
    public UpdateSketch rebuild() {
        throw new SketchesReadOnlyException();
    }

    @Override
    public void reset() {
        throw new SketchesReadOnlyException();
    }

    @Override
    long[] getCache() {
        long lgArrLongs = this.mem_.getByte(4L) & 0xFF;
        int preambleLongs = this.mem_.getByte(0L) & 0x3F;
        long[] cacheArr = new long[1 << (int)lgArrLongs];
        WritableMemory mem = WritableMemory.wrap((long[])cacheArr);
        this.mem_.copyTo((long)(preambleLongs << 3), mem, 0L, (long)(8 << (int)lgArrLongs));
        return cacheArr;
    }

    @Override
    int getCurrentPreambleLongs(boolean compact) {
        if (!compact) {
            return PreambleUtil.extractPreLongs((Memory)this.mem_);
        }
        return DirectQuickSelectSketchR.computeCompactPreLongs(this.getThetaLong(), this.isEmpty(), this.getRetainedEntries(true));
    }

    WritableMemory getMemory() {
        return this.mem_;
    }

    @Override
    float getP() {
        return this.mem_.getFloat(12L);
    }

    @Override
    long getSeed() {
        return this.seed_;
    }

    @Override
    short getSeedHash() {
        return (short)PreambleUtil.extractSeedHash((Memory)this.mem_);
    }

    @Override
    boolean isDirty() {
        return false;
    }

    @Override
    boolean isOutOfSpace(int numEntries) {
        return numEntries > this.hashTableThreshold_;
    }

    @Override
    int getLgArrLongs() {
        return this.mem_.getByte(4L) & 0xFF;
    }

    int getLgRF() {
        return this.mem_.getByte(0L) >>> 6 & 3;
    }

    @Override
    UpdateReturnState hashUpdate(long hash) {
        throw new SketchesReadOnlyException();
    }

    static final int setHashTableThreshold(int lgNomLongs, int lgArrLongs) {
        double fraction = lgArrLongs <= lgNomLongs ? 0.9375 : 0.9375;
        return (int)Math.floor(fraction * (double)(1 << lgArrLongs));
    }
}

