/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.ingestion;

import com.facebook.presto.common.Page;
import com.facebook.presto.druid.DruidClient;
import com.facebook.presto.druid.DruidConfig;
import com.facebook.presto.druid.ingestion.DruidIngestTask;
import com.facebook.presto.druid.ingestion.DruidIngestionTableHandle;
import com.facebook.presto.druid.ingestion.DruidPageWriter;
import com.facebook.presto.spi.ConnectorPageSink;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;

public class DruidPageSink
implements ConnectorPageSink {
    public static final String TIMESTAMP_COLUMN = "__time";
    private final DruidConfig druidConfig;
    private final DruidClient druidClient;
    private final DruidIngestionTableHandle tableHandle;
    private final DruidPageWriter druidPageWriter;
    private final Path dataPath;
    private List<String> dataFileList;

    public DruidPageSink(DruidConfig druidConfig, DruidClient druidClient, DruidIngestionTableHandle tableHandle, DruidPageWriter druidPageWriter) {
        this.druidConfig = Objects.requireNonNull(druidConfig, "druidConfig is null");
        this.druidClient = Objects.requireNonNull(druidClient, "druidClient is null");
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        this.druidPageWriter = Objects.requireNonNull(druidPageWriter, "pageWriter is null");
        this.dataPath = new Path(druidConfig.getIngestionStoragePath(), tableHandle.getTableName() + UUID.randomUUID());
        this.dataFileList = new ArrayList<String>();
    }

    public CompletableFuture<?> appendPage(Page page) {
        this.dataFileList.add(this.druidPageWriter.append(page, this.tableHandle, this.dataPath).toString());
        return NOT_BLOCKED;
    }

    public CompletableFuture<Collection<Slice>> finish() {
        DruidIngestTask ingestTask = new DruidIngestTask.Builder().withDataSource(this.tableHandle.getTableName()).withInputSource(this.dataPath, this.dataFileList).withTimestampColumn(TIMESTAMP_COLUMN).withDimensions(this.tableHandle.getColumns().stream().filter(column -> !column.getColumnName().equals(TIMESTAMP_COLUMN)).map(column -> new DruidIngestTask.DruidIngestDimension(column.getDataType().getIngestType(), column.getColumnName())).collect(Collectors.toList())).withAppendToExisting(true).build();
        this.druidClient.ingestData(ingestTask);
        return CompletableFuture.completedFuture(ImmutableList.of());
    }

    public void abort() {
    }
}

