/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.segment;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.druid.DruidColumnHandle;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.column.ColumnReader;
import com.facebook.presto.druid.column.SimpleReadableOffset;
import com.facebook.presto.druid.segment.SegmentIndexSource;
import com.facebook.presto.druid.segment.SegmentReader;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.data.ReadableOffset;

public class DruidSegmentReader
implements SegmentReader {
    private static final int BATCH_SIZE = 1024;
    private final Map<String, ColumnReader> columnValueSelectors;
    private final long totalRowCount;
    private QueryableIndex queryableIndex;
    private long currentPosition;
    private int currentBatchSize;

    public DruidSegmentReader(SegmentIndexSource segmentIndexSource, List<ColumnHandle> columns) {
        try {
            this.queryableIndex = segmentIndexSource.loadIndex(columns);
            this.totalRowCount = this.queryableIndex.getNumRows();
            ImmutableMap.Builder selectorsBuilder = ImmutableMap.builder();
            for (ColumnHandle column : columns) {
                DruidColumnHandle druidColumn = (DruidColumnHandle)column;
                String columnName = druidColumn.getColumnName();
                Type type = druidColumn.getColumnType();
                BaseColumn baseColumn = this.queryableIndex.getColumnHolder(columnName).getColumn();
                ColumnValueSelector valueSelector = baseColumn.makeColumnValueSelector((ReadableOffset)new SimpleReadableOffset());
                selectorsBuilder.put((Object)columnName, (Object)ColumnReader.createColumnReader(type, valueSelector));
            }
            this.columnValueSelectors = selectorsBuilder.build();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, "failed to load druid segment");
        }
    }

    @Override
    public int nextBatch() {
        this.currentBatchSize = Math.toIntExact(Math.min(1024L, this.totalRowCount - this.currentPosition));
        this.currentPosition += (long)this.currentBatchSize;
        return this.currentBatchSize;
    }

    @Override
    public Block readBlock(Type type, String columnName) {
        return this.columnValueSelectors.get(columnName).readBlock(type, this.currentBatchSize);
    }
}

