/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.segment;

import com.facebook.presto.druid.DataInputSource;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.segment.IndexFileSource;
import com.facebook.presto.druid.zip.CentralDirectoryFileHeader;
import com.facebook.presto.druid.zip.EndOfCentralDirectoryRecord;
import com.facebook.presto.druid.zip.Zip64EndOfCentralDirectory;
import com.facebook.presto.druid.zip.Zip64EndOfCentralDirectoryLocator;
import com.facebook.presto.druid.zip.ZipFileData;
import com.facebook.presto.druid.zip.ZipFileEntry;
import com.facebook.presto.druid.zip.ZipUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class ZipIndexFileSource
implements IndexFileSource,
Closeable,
AutoCloseable {
    public static final int LOCAL_HEADER_SIGNATURE = 67324752;
    public static final int LOCAL_HEADER_FIXED_DATA_SIZE = 30;
    public static final int LOCAL_HEADER_FILENAME_LENGTH_OFFSET = 26;
    public static final int LOCAL_HEADER_EXTRA_FIELD_LENGTH_OFFSET = 28;
    private final DataInputSource dataInputSource;
    private ZipFileData zipData;

    public ZipIndexFileSource(DataInputSource dataInputSource) {
        this.dataInputSource = Objects.requireNonNull(dataInputSource, "dataInputSource is null");
        this.zipData = this.readCentralDirectory();
    }

    @Override
    public byte[] readFile(String fileName) throws IOException {
        ZipFileEntry entry = this.zipData.getEntry(fileName);
        if (entry == null) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, String.format("Zip doesn't contain file: %s", fileName));
        }
        byte[] fileData = new byte[(int)entry.getSize()];
        this.readFully(entry, 0L, fileData, 0, fileData.length);
        return fileData;
    }

    @Override
    public final void readFile(String fileName, long position, byte[] buffer) throws IOException {
        ZipFileEntry entry = this.zipData.getEntry(fileName);
        if (entry == null) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, String.format("Zip doesn't contain file: %s", fileName));
        }
        this.readFully(entry, position, buffer, 0, buffer.length);
    }

    private void readFully(ZipFileEntry entry, long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        long offset = entry.getLocalHeaderOffset();
        byte[] fileHeader = new byte[30];
        this.dataInputSource.readFully(offset, fileHeader);
        offset += (long)fileHeader.length;
        if (!ZipUtil.arrayStartsWith(fileHeader, ZipUtil.intToLittleEndian(67324752))) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, String.format("The file '%s' is not a correctly formatted zip file: Expected a File Header at offset %d, but not present.", entry.getName(), offset));
        }
        int nameLength = ZipUtil.getUnsignedShort(fileHeader, 26);
        int extraFieldLength = ZipUtil.getUnsignedShort(fileHeader, 28);
        int compressedSize = (int)entry.getCompressedSize();
        byte[] compressedData = new byte[compressedSize];
        this.dataInputSource.readFully(offset += (long)(nameLength + extraFieldLength), compressedData);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(compressedData), new Inflater(true));
        try {
            inflaterInputStream.skip(position);
            int size = ZipIndexFileSource.chunkedRead(inflaterInputStream, buffer, bufferOffset, bufferLength);
            Preconditions.checkState((size == bufferLength ? 1 : 0) != 0);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, String.format("Malformed zip file: %s", entry.getName()));
        }
    }

    private static int chunkedRead(InflaterInputStream inflaterInputStream, byte[] buffer, int offset, int length) throws IOException {
        int position = offset;
        int bytesRead = 0;
        while (position - offset < length && bytesRead != -1) {
            bytesRead = inflaterInputStream.read(buffer, position, offset + length - position);
            if (bytesRead <= 0) continue;
            position += bytesRead;
        }
        return position - offset;
    }

    private ZipFileData readCentralDirectory() {
        try {
            long centralDirectoryEndOffset = this.getCentralDirectoryEndOffset();
            ZipFileData fileData = new ZipFileData(StandardCharsets.UTF_8);
            EndOfCentralDirectoryRecord.read(fileData, this.dataInputSource, centralDirectoryEndOffset);
            if (fileData.isMaybeZip64()) {
                try {
                    Zip64EndOfCentralDirectoryLocator.read(fileData, this.dataInputSource, centralDirectoryEndOffset - 20L);
                    Zip64EndOfCentralDirectory.read(fileData, this.dataInputSource, fileData.getZip64EndOfCentralDirectoryOffset());
                }
                catch (ZipException zipException) {
                    // empty catch block
                }
            }
            if (fileData.isZip64()) {
                this.readCentralDirectoryFileHeaders(fileData, this.dataInputSource, fileData.getCentralDirectoryOffset(), fileData.getCharset(), fileData.getExpectedEntries());
            } else {
                long centralDirectoryOffset = centralDirectoryEndOffset - fileData.getCentralDirectorySize();
                if ((int)centralDirectoryOffset == (int)fileData.getCentralDirectoryOffset()) {
                    this.readCentralDirectoryFileHeaders(fileData, this.dataInputSource, centralDirectoryOffset, fileData.getCharset());
                } else {
                    this.readCentralDirectoryFileHeaders(fileData, this.dataInputSource, fileData.getCentralDirectoryOffset(), fileData.getCharset(), fileData.getExpectedEntries());
                }
            }
            return fileData;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, (Throwable)e);
        }
    }

    private long getCentralDirectoryEndOffset() throws IOException {
        long fileSize = this.dataInputSource.getSize();
        byte[] signature = ZipUtil.intToLittleEndian(101010256);
        byte[] buffer = new byte[(int)Math.min(64L, fileSize)];
        int readLength = buffer.length;
        if (readLength < 22) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, String.format("Zip file '%s' is malformed. It does not contain an end of central directory record.", this.dataInputSource.getId()));
        }
        for (long offset = fileSize - (long)buffer.length; offset >= 0L; offset -= (long)readLength) {
            this.dataInputSource.readFully(offset, buffer, 0, readLength);
            int signatureLocation = this.scanBackwards(signature, buffer, buffer.length);
            while (signatureLocation != -1) {
                long readCommentLength;
                int commentLength;
                long eocdSize = fileSize - offset - (long)signatureLocation;
                if (eocdSize >= 22L && (long)(commentLength = ZipUtil.getUnsignedShort(buffer, signatureLocation + 20)) == (readCommentLength = eocdSize - 22L)) {
                    return offset + (long)signatureLocation;
                }
                signatureLocation = this.scanBackwards(signature, buffer, signatureLocation - 1);
            }
            readLength = buffer.length - 3;
            buffer[buffer.length - 3] = buffer[0];
            buffer[buffer.length - 2] = buffer[1];
            buffer[buffer.length - 1] = buffer[2];
        }
        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, String.format("Zip file '%s' is malformed. It does not contain an end of central directory record.", this.dataInputSource.getId()));
    }

    private void readCentralDirectoryFileHeaders(ZipFileData fileData, DataInputSource dataInputSource, long fileOffset, Charset charset, long count) throws IOException {
        try {
            long position = fileOffset;
            for (long i = 0L; i < count; ++i) {
                position += CentralDirectoryFileHeader.read(fileData, dataInputSource, position, charset);
            }
        }
        catch (ZipException e) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, (Throwable)e);
        }
    }

    private void readCentralDirectoryFileHeaders(ZipFileData fileData, DataInputSource dataInputSource, long fileOffset, Charset charset) throws IOException {
        try {
            long position = fileOffset;
            while (position - fileOffset < fileData.getCentralDirectorySize()) {
                position += CentralDirectoryFileHeader.read(fileData, dataInputSource, position, charset);
            }
        }
        catch (ZipException e) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_SEGMENT_LOAD_ERROR, (Throwable)e);
        }
    }

    private int scanBackwards(byte[] target, byte[] buffer, int offset) {
        int start;
        for (int i = start = Math.min(offset, buffer.length - target.length); i >= 0; --i) {
            for (int j = 0; j < target.length && buffer[i + j] == target[j]; ++j) {
                if (j != target.length - 1) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.dataInputSource.close();
    }
}

