/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.zip;

import com.facebook.presto.druid.DataInputSource;
import com.facebook.presto.druid.zip.ZipFileData;
import com.facebook.presto.druid.zip.ZipUtil;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.zip.ZipException;

public class Zip64EndOfCentralDirectoryLocator {
    public static final int SIGNATURE = 117853008;
    public static final int FIXED_DATA_SIZE = 20;
    public static final int ZIP64_EOCD_OFFSET_OFFSET = 8;

    private Zip64EndOfCentralDirectoryLocator() {
    }

    public static ZipFileData read(ZipFileData file, DataInputSource dataInputSource, long position) throws IOException {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (String)"Zip file data for source:%s is null", (Object)dataInputSource.getId());
        byte[] fixedSizeData = new byte[20];
        dataInputSource.readFully(position, fixedSizeData, 0, 20);
        if (!ZipUtil.arrayStartsWith(fixedSizeData, ZipUtil.intToLittleEndian(117853008))) {
            throw new ZipException(String.format("Malformed Zip64 Central Directory Locator; does not start with %08x", 117853008));
        }
        file.setZip64(true);
        file.setZip64EndOfCentralDirectoryOffset(ZipUtil.getUnsignedLong(fixedSizeData, 8));
        return file;
    }
}

