/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.DimExtractionFn;
import org.apache.druid.query.extraction.ExtractionFn;

@JsonTypeName(value="lower")
public class LowerExtractionFn
extends DimExtractionFn {
    private final Locale locale;
    @JsonProperty
    private final String localeString;

    public LowerExtractionFn(@JsonProperty(value="locale") String localeString) {
        this.localeString = localeString;
        this.locale = localeString == null ? Locale.getDefault() : Locale.forLanguageTag(localeString);
    }

    @Override
    @Nullable
    public String apply(@Nullable String key) {
        if (NullHandling.isNullOrEquivalent((String)key)) {
            return null;
        }
        return key.toLowerCase(this.locale);
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public byte[] getCacheKey() {
        byte[] localeBytes = StringUtils.toUtf8((String)StringUtils.nullToEmptyNonDruidDataString((String)this.localeString));
        return ByteBuffer.allocate(2 + localeBytes.length).put((byte)12).put((byte)-1).put(localeBytes).array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LowerExtractionFn that = (LowerExtractionFn)o;
        return Objects.equals(this.locale, that.locale) && Objects.equals(this.localeString, that.localeString);
    }

    public int hashCode() {
        return Objects.hash(this.locale, this.localeString);
    }
}

