/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.annotations.SubclassesMustOverrideEqualsAndHashCode;
import org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.druid.query.filter.Filter;

@SubclassesMustOverrideEqualsAndHashCode
public class FilterTuning {
    private final boolean useBitmapIndex;
    private final int minCardinalityToUseBitmapIndex;
    private final int maxCardinalityToUseBitmapIndex;

    public static FilterTuning createDefault(Filter filter, BitmapIndexSelector selector) {
        return new FilterTuning(filter.supportsBitmapIndex(selector), null, null);
    }

    @JsonCreator
    public FilterTuning(@JsonProperty(value="useBitmapIndex") @Nullable Boolean useBitmapIndex, @JsonProperty(value="minCardinalityToUseBitmapIndex") @Nullable Integer minCardinalityToUseBitmapIndex, @JsonProperty(value="maxCardinalityToUseBitmapIndex") @Nullable Integer maxCardinalityToUseBitmapIndex) {
        this.useBitmapIndex = useBitmapIndex != null ? useBitmapIndex : true;
        this.minCardinalityToUseBitmapIndex = minCardinalityToUseBitmapIndex != null ? minCardinalityToUseBitmapIndex : 0;
        this.maxCardinalityToUseBitmapIndex = maxCardinalityToUseBitmapIndex != null ? maxCardinalityToUseBitmapIndex : Integer.MAX_VALUE;
    }

    @JsonProperty
    public boolean getUseBitmapIndex() {
        return this.useBitmapIndex;
    }

    @JsonProperty
    public int getMinCardinalityToUseBitmapIndex() {
        return this.minCardinalityToUseBitmapIndex;
    }

    @JsonProperty
    public int getMaxCardinalityToUseBitmapIndex() {
        return this.maxCardinalityToUseBitmapIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterTuning that = (FilterTuning)o;
        return Objects.equals(this.useBitmapIndex, that.useBitmapIndex) && Objects.equals(this.minCardinalityToUseBitmapIndex, that.minCardinalityToUseBitmapIndex) && Objects.equals(this.maxCardinalityToUseBitmapIndex, that.maxCardinalityToUseBitmapIndex);
    }

    public int hashCode() {
        return Objects.hash(this.useBitmapIndex, this.minCardinalityToUseBitmapIndex, this.maxCardinalityToUseBitmapIndex);
    }

    public String toString() {
        return "FilterTuning{useBitmapIndex=" + this.useBitmapIndex + ", minCardinalityToUseBitmapIndex=" + this.minCardinalityToUseBitmapIndex + ", maxCardinalityToUseBitmapIndex=" + this.maxCardinalityToUseBitmapIndex + '}';
    }
}

