/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.AbstractOptimizableDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.FalseDimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.filter.InFilter;

public class InDimFilter
extends AbstractOptimizableDimFilter
implements DimFilter {
    public static final int NUMERIC_HASHING_THRESHOLD = 16;
    private final Set<String> values;
    private final String dimension;
    @Nullable
    private final ExtractionFn extractionFn;
    @Nullable
    private final FilterTuning filterTuning;
    private final Supplier<DruidLongPredicate> longPredicateSupplier;
    private final Supplier<DruidFloatPredicate> floatPredicateSupplier;
    private final Supplier<DruidDoublePredicate> doublePredicateSupplier;
    @JsonIgnore
    private byte[] cacheKey;

    @JsonCreator
    public InDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="values") Set<String> values, @JsonProperty(value="extractionFn") @Nullable ExtractionFn extractionFn, @JsonProperty(value="filterTuning") @Nullable FilterTuning filterTuning) {
        Preconditions.checkNotNull((Object)dimension, (Object)"dimension can not be null");
        Preconditions.checkArgument((values != null ? 1 : 0) != 0, (Object)"values can not be null");
        this.values = NullHandling.sqlCompatible() || values.stream().noneMatch(NullHandling::needsEmptyToNull) ? values : values.stream().map(NullHandling::emptyToNullIfNeeded).collect(Collectors.toSet());
        this.dimension = dimension;
        this.extractionFn = extractionFn;
        this.filterTuning = filterTuning;
        this.longPredicateSupplier = this.getLongPredicateSupplier();
        this.floatPredicateSupplier = this.getFloatPredicateSupplier();
        this.doublePredicateSupplier = this.getDoublePredicateSupplier();
    }

    @VisibleForTesting
    public InDimFilter(String dimension, Collection<String> values, @Nullable ExtractionFn extractionFn) {
        this(dimension, new HashSet<String>(values), extractionFn, null);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public Set<String> getValues() {
        return this.values;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public FilterTuning getFilterTuning() {
        return this.filterTuning;
    }

    public byte[] getCacheKey() {
        if (this.cacheKey == null) {
            ArrayList<String> sortedValues = new ArrayList<String>(this.values);
            sortedValues.sort(Comparator.nullsFirst(Ordering.natural()));
            Hasher hasher = Hashing.sha256().newHasher();
            for (String v : sortedValues) {
                if (v == null) {
                    hasher.putInt(0);
                    continue;
                }
                hasher.putString((CharSequence)v, StandardCharsets.UTF_8);
            }
            this.cacheKey = new CacheKeyBuilder(9).appendString(this.dimension).appendByte((byte)-1).appendByteArray(this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey()).appendByte((byte)-1).appendByteArray(hasher.hash().asBytes()).build();
        }
        return this.cacheKey;
    }

    @Override
    public DimFilter optimize() {
        InDimFilter inFilter = this.optimizeLookup();
        if (inFilter.values.isEmpty()) {
            return FalseDimFilter.instance();
        }
        if (inFilter.values.size() == 1) {
            return new SelectorDimFilter(inFilter.dimension, inFilter.values.iterator().next(), inFilter.getExtractionFn(), this.filterTuning);
        }
        return inFilter;
    }

    private InDimFilter optimizeLookup() {
        if (this.extractionFn instanceof LookupExtractionFn && ((LookupExtractionFn)this.extractionFn).isOptimize()) {
            LookupExtractionFn exFn = (LookupExtractionFn)this.extractionFn;
            LookupExtractor lookup = exFn.getLookup();
            HashSet<String> keys = new HashSet<String>();
            for (String value : this.values) {
                String convertedValue = NullHandling.emptyToNullIfNeeded((String)value);
                if (!exFn.isRetainMissingValue() && Objects.equals(convertedValue, exFn.getReplaceMissingValueWith())) {
                    return this;
                }
                keys.addAll(lookup.unapply(convertedValue));
                if (!exFn.isRetainMissingValue() || !NullHandling.isNullOrEquivalent((String)lookup.apply(convertedValue))) continue;
                keys.add(convertedValue);
            }
            if (keys.isEmpty()) {
                return this;
            }
            return new InDimFilter(this.dimension, keys, null, this.filterTuning);
        }
        return this;
    }

    @Override
    public Filter toFilter() {
        return new InFilter(this.dimension, this.values, this.longPredicateSupplier, this.floatPredicateSupplier, this.doublePredicateSupplier, this.extractionFn, this.filterTuning);
    }

    @Override
    @Nullable
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        if (!Objects.equals(this.getDimension(), dimension) || this.getExtractionFn() != null) {
            return null;
        }
        TreeRangeSet retSet = TreeRangeSet.create();
        for (String value : this.values) {
            String valueEquivalent = NullHandling.nullToEmptyIfNeeded((String)value);
            if (valueEquivalent == null) {
                retSet.add(Range.lessThan((Comparable)((Object)"")));
                continue;
            }
            retSet.add(Range.singleton((Comparable)((Object)valueEquivalent)));
        }
        return retSet;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.dimension);
    }

    public String toString() {
        DimFilter.DimFilterToStringBuilder builder = new DimFilter.DimFilterToStringBuilder();
        return builder.appendDimension(this.dimension, this.extractionFn).append(" IN (").append(Joiner.on((String)", ").join(Iterables.transform(this.values, StringUtils::nullToEmptyNonDruidDataString))).append(")").appendFilterTuning(this.filterTuning).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InDimFilter that = (InDimFilter)o;
        return this.values.equals(that.values) && this.dimension.equals(that.dimension) && Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.dimension, this.extractionFn, this.filterTuning);
    }

    private DruidLongPredicate createLongPredicate() {
        LongArrayList longs = new LongArrayList(this.values.size());
        for (String value : this.values) {
            Long longValue = DimensionHandlerUtils.convertObjectToLong(value);
            if (longValue == null) continue;
            longs.add(longValue.longValue());
        }
        if (longs.size() > 16) {
            LongOpenHashSet longHashSet = new LongOpenHashSet((LongCollection)longs);
            return arg_0 -> ((LongOpenHashSet)longHashSet).contains(arg_0);
        }
        long[] longArray = longs.toLongArray();
        Arrays.sort(longArray);
        return input -> Arrays.binarySearch(longArray, input) >= 0;
    }

    private Supplier<DruidLongPredicate> getLongPredicateSupplier() {
        Supplier longPredicate = this::createLongPredicate;
        return Suppliers.memoize((Supplier)longPredicate);
    }

    private DruidFloatPredicate createFloatPredicate() {
        IntArrayList floatBits = new IntArrayList(this.values.size());
        for (String value : this.values) {
            Float floatValue = DimensionHandlerUtils.convertObjectToFloat(value);
            if (floatValue == null) continue;
            floatBits.add(Float.floatToIntBits(floatValue.floatValue()));
        }
        if (floatBits.size() > 16) {
            IntOpenHashSet floatBitsHashSet = new IntOpenHashSet((IntCollection)floatBits);
            return input -> floatBitsHashSet.contains(Float.floatToIntBits(input));
        }
        int[] floatBitsArray = floatBits.toIntArray();
        Arrays.sort(floatBitsArray);
        return input -> Arrays.binarySearch(floatBitsArray, Float.floatToIntBits(input)) >= 0;
    }

    private Supplier<DruidFloatPredicate> getFloatPredicateSupplier() {
        Supplier floatPredicate = this::createFloatPredicate;
        return Suppliers.memoize((Supplier)floatPredicate);
    }

    private DruidDoublePredicate createDoublePredicate() {
        LongArrayList doubleBits = new LongArrayList(this.values.size());
        for (String value : this.values) {
            Double doubleValue = DimensionHandlerUtils.convertObjectToDouble(value);
            if (doubleValue == null) continue;
            doubleBits.add(Double.doubleToLongBits(doubleValue));
        }
        if (doubleBits.size() > 16) {
            LongOpenHashSet doubleBitsHashSet = new LongOpenHashSet((LongCollection)doubleBits);
            return input -> doubleBitsHashSet.contains(Double.doubleToLongBits(input));
        }
        long[] doubleBitsArray = doubleBits.toLongArray();
        Arrays.sort(doubleBitsArray);
        return input -> Arrays.binarySearch(doubleBitsArray, Double.doubleToLongBits(input)) >= 0;
    }

    private Supplier<DruidDoublePredicate> getDoublePredicateSupplier() {
        Supplier doublePredicate = this::createDoublePredicate;
        return Suppliers.memoize((Supplier)doublePredicate);
    }
}

