/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.AbstractOptimizableDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.SelectorPredicateFactory;
import org.apache.druid.segment.filter.DimensionPredicateFilter;
import org.apache.druid.segment.filter.SelectorFilter;

public class SelectorDimFilter
extends AbstractOptimizableDimFilter
implements DimFilter {
    private final String dimension;
    @Nullable
    private final String value;
    @Nullable
    private final ExtractionFn extractionFn;
    @Nullable
    private final FilterTuning filterTuning;
    private final DruidPredicateFactory predicateFactory;

    @JsonCreator
    public SelectorDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="value") String value, @JsonProperty(value="extractionFn") @Nullable ExtractionFn extractionFn, @JsonProperty(value="filterTuning") @Nullable FilterTuning filterTuning) {
        Preconditions.checkArgument((dimension != null ? 1 : 0) != 0, (Object)"dimension must not be null");
        this.dimension = dimension;
        this.value = NullHandling.emptyToNullIfNeeded((String)value);
        this.extractionFn = extractionFn;
        this.filterTuning = filterTuning;
        this.predicateFactory = new SelectorPredicateFactory(this.value);
    }

    public SelectorDimFilter(String dimension, String value, @Nullable ExtractionFn extractionFn) {
        this(dimension, value, extractionFn, null);
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(0).appendByte((byte)-1).appendString(this.dimension).appendByte((byte)-1).appendByte(this.value == null ? (byte)1 : 0).appendString(this.value).appendByte((byte)-1).appendByteArray(this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey()).build();
    }

    @Override
    public DimFilter optimize() {
        return new InDimFilter(this.dimension, Collections.singleton(this.value), this.extractionFn, this.filterTuning).optimize();
    }

    @Override
    public Filter toFilter() {
        if (this.extractionFn == null) {
            return new SelectorFilter(this.dimension, this.value, this.filterTuning);
        }
        return new DimensionPredicateFilter(this.dimension, this.predicateFactory, this.extractionFn, this.filterTuning);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @Nullable
    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @Nullable
    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public FilterTuning getFilterTuning() {
        return this.filterTuning;
    }

    public String toString() {
        return new DimFilter.DimFilterToStringBuilder().appendDimension(this.dimension, this.extractionFn).appendEquals(this.value).appendFilterTuning(this.filterTuning).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectorDimFilter that = (SelectorDimFilter)o;
        return this.dimension.equals(that.dimension) && Objects.equals(this.value, that.value) && Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.value, this.extractionFn, this.filterTuning);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        if (!Objects.equals(this.getDimension(), dimension) || this.getExtractionFn() != null) {
            return null;
        }
        TreeRangeSet retSet = TreeRangeSet.create();
        String valueEquivalent = NullHandling.nullToEmptyIfNeeded((String)this.value);
        if (valueEquivalent == null) {
            retSet.add(Range.lessThan((Comparable)((Object)"")));
        } else {
            retSet.add(Range.singleton((Comparable)((Object)valueEquivalent)));
        }
        return retSet;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.dimension);
    }
}

