/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.vector;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class FloatGroupByVectorColumnSelector
implements GroupByVectorColumnSelector {
    private final VectorValueSelector selector;

    FloatGroupByVectorColumnSelector(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public int getGroupingKeySize() {
        return 4;
    }

    @Override
    public void writeKeys(WritableMemory keySpace, int keySize, int keyOffset, int startRow, int endRow) {
        float[] vector = this.selector.getFloatVector();
        if (keySize == 4) {
            keySpace.putFloatArray((long)keyOffset, vector, startRow, endRow - startRow);
        } else {
            int i = startRow;
            int j = keyOffset;
            while (i < endRow) {
                keySpace.putFloat((long)j, vector[i]);
                ++i;
                j += keySize;
            }
        }
    }

    @Override
    public void writeKeyToResultRow(Memory keyMemory, int keyOffset, ResultRow resultRow, int resultRowPosition) {
        resultRow.set(resultRowPosition, Float.valueOf(keyMemory.getFloat((long)keyOffset)));
    }
}

