/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.vector;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class LongGroupByVectorColumnSelector
implements GroupByVectorColumnSelector {
    private final VectorValueSelector selector;

    LongGroupByVectorColumnSelector(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public int getGroupingKeySize() {
        return 8;
    }

    @Override
    public void writeKeys(WritableMemory keySpace, int keySize, int keyOffset, int startRow, int endRow) {
        long[] vector = this.selector.getLongVector();
        if (keySize == 8) {
            keySpace.putLongArray((long)keyOffset, vector, startRow, endRow - startRow);
        } else {
            int i = startRow;
            int j = keyOffset;
            while (i < endRow) {
                keySpace.putLong((long)j, vector[i]);
                ++i;
                j += keySize;
            }
        }
    }

    @Override
    public void writeKeyToResultRow(Memory keyMemory, int keyOffset, ResultRow resultRow, int resultRowPosition) {
        resultRow.set(resultRowPosition, keyMemory.getLong((long)keyOffset));
    }
}

