/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeseries;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import org.apache.commons.lang.StringUtils;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.Result;
import org.apache.druid.query.ResultGranularTimestampComparator;
import org.apache.druid.query.ResultMergeQueryRunner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.timeseries.DefaultTimeseriesQueryMetricsFactory;
import org.apache.druid.query.timeseries.TimeseriesBinaryFn;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryMetrics;
import org.apache.druid.query.timeseries.TimeseriesQueryMetricsFactory;
import org.apache.druid.query.timeseries.TimeseriesResultBuilder;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.RowAdapters;
import org.apache.druid.segment.RowBasedColumnSelectorFactory;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.joda.time.DateTime;

public class TimeseriesQueryQueryToolChest
extends QueryToolChest<Result<TimeseriesResultValue>, TimeseriesQuery> {
    private static final byte TIMESERIES_QUERY = 0;
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private static final TypeReference<Result<TimeseriesResultValue>> TYPE_REFERENCE = new TypeReference<Result<TimeseriesResultValue>>(){};
    private final TimeseriesQueryMetricsFactory queryMetricsFactory;

    @VisibleForTesting
    public TimeseriesQueryQueryToolChest() {
        this(DefaultTimeseriesQueryMetricsFactory.instance());
    }

    @Inject
    public TimeseriesQueryQueryToolChest(TimeseriesQueryMetricsFactory queryMetricsFactory) {
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @Override
    public QueryRunner<Result<TimeseriesResultValue>> mergeResults(QueryRunner<Result<TimeseriesResultValue>> queryRunner) {
        ResultMergeQueryRunner<Result<TimeseriesResultValue>> resultMergeQueryRunner = new ResultMergeQueryRunner<Result<TimeseriesResultValue>>(queryRunner, this::createResultComparator, this::createMergeFn){

            @Override
            public Sequence<Result<TimeseriesResultValue>> doRun(QueryRunner<Result<TimeseriesResultValue>> baseRunner, QueryPlus<Result<TimeseriesResultValue>> queryPlus, ResponseContext context) {
                int limit = ((TimeseriesQuery)queryPlus.getQuery()).getLimit();
                Sequence<Result<TimeseriesResultValue>> result = super.doRun(baseRunner, queryPlus.withQuery(((TimeseriesQuery)queryPlus.getQuery()).withPostAggregatorSpecs((List<PostAggregator>)ImmutableList.of())), context);
                if (limit < Integer.MAX_VALUE) {
                    return result.limit((long)limit);
                }
                return result;
            }
        };
        return (queryPlus, responseContext) -> {
            List val;
            TimeseriesQuery query = (TimeseriesQuery)queryPlus.getQuery();
            Sequence baseResults = resultMergeQueryRunner.run(queryPlus.withQuery(queryPlus.getQuery().withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)"grandTotal", (Object)false))), responseContext);
            Sequence finalSequence = query.getGranularity().equals(Granularities.ALL) && !query.isSkipEmptyBuckets() ? ((val = baseResults.toList()).isEmpty() ? Sequences.simple(Collections.singletonList(this.getNullTimeseriesResultValue(query))) : Sequences.simple((Iterable)val)) : baseResults;
            if (query.isGrandTotal()) {
                Object[] grandTotals = new Object[query.getAggregatorSpecs().size()];
                Sequence mappedSequence = Sequences.map((Sequence)finalSequence, resultValue -> {
                    for (int i = 0; i < query.getAggregatorSpecs().size(); ++i) {
                        AggregatorFactory aggregatorFactory = query.getAggregatorSpecs().get(i);
                        Object value = ((TimeseriesResultValue)resultValue.getValue()).getMetric(aggregatorFactory.getName());
                        grandTotals[i] = grandTotals[i] == null ? value : aggregatorFactory.combine(grandTotals[i], value);
                    }
                    return resultValue;
                });
                return Sequences.concat((Iterable)ImmutableList.of((Object)mappedSequence, (Object)Sequences.simple(() -> {
                    HashMap<String, Object> totalsMap = new HashMap<String, Object>();
                    for (int i = 0; i < query.getAggregatorSpecs().size(); ++i) {
                        totalsMap.put(query.getAggregatorSpecs().get(i).getName(), grandTotals[i]);
                    }
                    Result<TimeseriesResultValue> result = new Result<TimeseriesResultValue>(null, new TimeseriesResultValue(totalsMap));
                    return Collections.singletonList(result).iterator();
                })));
            }
            return finalSequence;
        };
    }

    @Override
    public BinaryOperator<Result<TimeseriesResultValue>> createMergeFn(Query<Result<TimeseriesResultValue>> query) {
        TimeseriesQuery timeseriesQuery = (TimeseriesQuery)query;
        return new TimeseriesBinaryFn(timeseriesQuery.getGranularity(), timeseriesQuery.getAggregatorSpecs());
    }

    @Override
    public Comparator<Result<TimeseriesResultValue>> createResultComparator(Query<Result<TimeseriesResultValue>> query) {
        return ResultGranularTimestampComparator.create(query.getGranularity(), query.isDescending());
    }

    private Result<TimeseriesResultValue> getNullTimeseriesResultValue(TimeseriesQuery query) {
        List<AggregatorFactory> aggregatorSpecs = query.getAggregatorSpecs();
        Aggregator[] aggregators = new Aggregator[aggregatorSpecs.size()];
        String[] aggregatorNames = new String[aggregatorSpecs.size()];
        for (int i = 0; i < aggregatorSpecs.size(); ++i) {
            aggregators[i] = aggregatorSpecs.get(i).factorize(RowBasedColumnSelectorFactory.create(RowAdapters.standardRow(), () -> new MapBasedRow(null, null), RowSignature.empty(), false));
            aggregatorNames[i] = aggregatorSpecs.get(i).getName();
        }
        DateTime start = query.getIntervals().isEmpty() ? DateTimes.EPOCH : query.getIntervals().get(0).getStart();
        TimeseriesResultBuilder bob = new TimeseriesResultBuilder(start);
        for (int i = 0; i < aggregatorSpecs.size(); ++i) {
            bob.addMetric(aggregatorNames[i], aggregators[i].get());
            aggregators[i].close();
        }
        return bob.build();
    }

    public TimeseriesQueryMetrics makeMetrics(TimeseriesQuery query) {
        TimeseriesQueryMetrics queryMetrics = this.queryMetricsFactory.makeMetrics();
        queryMetrics.query(query);
        return queryMetrics;
    }

    @Override
    public TypeReference<Result<TimeseriesResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<Result<TimeseriesResultValue>, Object, TimeseriesQuery> getCacheStrategy(final TimeseriesQuery query) {
        return new CacheStrategy<Result<TimeseriesResultValue>, Object, TimeseriesQuery>(){
            private final List<AggregatorFactory> aggs;
            {
                this.aggs = query.getAggregatorSpecs();
            }

            @Override
            public boolean isCacheable(TimeseriesQuery query2, boolean willMergeRunners) {
                return true;
            }

            @Override
            public byte[] computeCacheKey(TimeseriesQuery query2) {
                return new CacheKeyBuilder(0).appendBoolean(query2.isDescending()).appendBoolean(query2.isSkipEmptyBuckets()).appendCacheable((Cacheable)query2.getGranularity()).appendCacheable(query2.getDimensionsFilter()).appendCacheables(query2.getAggregatorSpecs()).appendCacheable(query2.getVirtualColumns()).appendInt(query2.getLimit()).build();
            }

            @Override
            public byte[] computeResultLevelCacheKey(TimeseriesQuery query2) {
                CacheKeyBuilder builder = new CacheKeyBuilder(0).appendBoolean(query2.isDescending()).appendBoolean(query2.isSkipEmptyBuckets()).appendCacheable((Cacheable)query2.getGranularity()).appendCacheable(query2.getDimensionsFilter()).appendCacheables(query2.getAggregatorSpecs()).appendCacheable(query2.getVirtualColumns()).appendCacheables(query2.getPostAggregatorSpecs()).appendInt(query2.getLimit()).appendString(query2.getTimestampResultField()).appendBoolean(query2.isGrandTotal());
                return builder.build();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Result<TimeseriesResultValue>, Object> prepareForCache(boolean isResultLevelCache) {
                return input -> {
                    TimeseriesResultValue results = (TimeseriesResultValue)input.getValue();
                    ArrayList retVal = Lists.newArrayListWithCapacity((int)(1 + this.aggs.size()));
                    if (isResultLevelCache) {
                        retVal.add(input.getTimestamp() == null ? null : Long.valueOf(input.getTimestamp().getMillis()));
                    } else {
                        retVal.add(((DateTime)Preconditions.checkNotNull((Object)input.getTimestamp(), (String)"timestamp of input[%s]", (Object[])new Object[]{input})).getMillis());
                    }
                    for (AggregatorFactory agg : this.aggs) {
                        retVal.add(results.getMetric(agg.getName()));
                    }
                    if (isResultLevelCache) {
                        for (PostAggregator postAgg : query.getPostAggregatorSpecs()) {
                            retVal.add(results.getMetric(postAgg.getName()));
                        }
                    }
                    return retVal;
                };
            }

            @Override
            public Function<Object, Result<TimeseriesResultValue>> pullFromCache(final boolean isResultLevelCache) {
                return new Function<Object, Result<TimeseriesResultValue>>(){
                    private final Granularity granularity;
                    {
                        this.granularity = query.getGranularity();
                    }

                    public Result<TimeseriesResultValue> apply(Object input) {
                        List results = (List)input;
                        LinkedHashMap retVal = Maps.newLinkedHashMap();
                        Iterator<Object> resultIter = results.iterator();
                        Number timestampNumber = (Number)resultIter.next();
                        DateTime timestamp = isResultLevelCache ? (timestampNumber == null ? null : this.granularity.toDateTime(timestampNumber.longValue())) : this.granularity.toDateTime(((Number)Preconditions.checkNotNull((Object)timestampNumber, (Object)"timestamp")).longValue());
                        CacheStrategy.fetchAggregatorsFromCache(aggs, resultIter, isResultLevelCache, (aggName, aggPosition, aggValueObject) -> retVal.put(aggName, aggValueObject));
                        if (isResultLevelCache) {
                            Iterator<PostAggregator> postItr = query.getPostAggregatorSpecs().iterator();
                            while (postItr.hasNext() && resultIter.hasNext()) {
                                retVal.put(postItr.next().getName(), resultIter.next());
                            }
                        }
                        return new Result<TimeseriesResultValue>(timestamp, new TimeseriesResultValue(retVal));
                    }
                };
            }
        };
    }

    @Override
    public QueryRunner<Result<TimeseriesResultValue>> preMergeQueryDecoration(QueryRunner<Result<TimeseriesResultValue>> runner) {
        return (queryPlus, responseContext) -> runner.run(queryPlus, responseContext);
    }

    @Override
    public Function<Result<TimeseriesResultValue>, Result<TimeseriesResultValue>> makePreComputeManipulatorFn(TimeseriesQuery query, MetricManipulationFn fn) {
        return this.makeComputeManipulatorFn(query, fn, false);
    }

    @Override
    public Function<Result<TimeseriesResultValue>, Result<TimeseriesResultValue>> makePostComputeManipulatorFn(TimeseriesQuery query, MetricManipulationFn fn) {
        return this.makeComputeManipulatorFn(query, fn, true);
    }

    @Override
    public RowSignature resultArraySignature(TimeseriesQuery query) {
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        rowSignatureBuilder.addTimeColumn();
        if (StringUtils.isNotEmpty((String)query.getTimestampResultField())) {
            rowSignatureBuilder.add(query.getTimestampResultField(), ValueType.LONG);
        }
        rowSignatureBuilder.addAggregators(query.getAggregatorSpecs());
        rowSignatureBuilder.addPostAggregators(query.getPostAggregatorSpecs());
        return rowSignatureBuilder.build();
    }

    @Override
    public Sequence<Object[]> resultsAsArrays(TimeseriesQuery query, Sequence<Result<TimeseriesResultValue>> resultSequence) {
        List<String> fields = this.resultArraySignature(query).getColumnNames();
        return Sequences.map(resultSequence, result -> {
            Object[] retVal = new Object[fields.size()];
            retVal[0] = result.getTimestamp().getMillis();
            Map<String, Object> resultMap = ((TimeseriesResultValue)result.getValue()).getBaseObject();
            for (int i = 1; i < fields.size(); ++i) {
                retVal[i] = resultMap.get(fields.get(i));
            }
            return retVal;
        });
    }

    private Function<Result<TimeseriesResultValue>, Result<TimeseriesResultValue>> makeComputeManipulatorFn(TimeseriesQuery query, MetricManipulationFn fn, boolean calculatePostAggs) {
        return result -> {
            TimeseriesResultValue holder = (TimeseriesResultValue)result.getValue();
            HashMap<String, Object> values = new HashMap<String, Object>(holder.getBaseObject());
            if (calculatePostAggs) {
                if (!query.getPostAggregatorSpecs().isEmpty()) {
                    for (AggregatorFactory agg : query.getAggregatorSpecs()) {
                        values.put(agg.getName(), holder.getMetric(agg.getName()));
                    }
                    for (PostAggregator postAgg : query.getPostAggregatorSpecs()) {
                        values.put(postAgg.getName(), postAgg.compute(values));
                    }
                }
                if (StringUtils.isNotEmpty((String)query.getTimestampResultField()) && result.getTimestamp() != null) {
                    DateTime timestamp = result.getTimestamp();
                    values.put(query.getTimestampResultField(), timestamp.getMillis());
                }
            }
            for (AggregatorFactory agg : query.getAggregatorSpecs()) {
                values.put(agg.getName(), fn.manipulate(agg, holder.getMetric(agg.getName())));
            }
            return new Result<TimeseriesResultValue>(result.getTimestamp(), new TimeseriesResultValue(values));
        };
    }
}

