/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.virtual.VirtualizedColumnSelectorFactory;

public class VirtualColumns
implements Cacheable {
    public static final VirtualColumns EMPTY = new VirtualColumns((List<VirtualColumn>)ImmutableList.of(), (Map<String, VirtualColumn>)ImmutableMap.of(), (Map<String, VirtualColumn>)ImmutableMap.of());
    private final List<VirtualColumn> virtualColumns;
    private final Map<String, VirtualColumn> withDotSupport;
    private final Map<String, VirtualColumn> withoutDotSupport;

    public static Pair<String, String> splitColumnName(String columnName) {
        int i = columnName.indexOf(46);
        if (i < 0) {
            return Pair.of((Object)columnName, null);
        }
        return Pair.of((Object)columnName.substring(0, i), (Object)columnName.substring(i + 1));
    }

    @JsonCreator
    public static VirtualColumns create(List<VirtualColumn> virtualColumns) {
        if (virtualColumns == null || virtualColumns.isEmpty()) {
            return EMPTY;
        }
        HashMap<String, VirtualColumn> withDotSupport = new HashMap<String, VirtualColumn>();
        HashMap<String, VirtualColumn> withoutDotSupport = new HashMap<String, VirtualColumn>();
        for (VirtualColumn vc : virtualColumns) {
            if (Strings.isNullOrEmpty((String)vc.getOutputName())) {
                throw new IAE("Empty or null virtualColumn name", new Object[0]);
            }
            if (vc.getOutputName().equals("__time")) {
                throw new IAE("virtualColumn name[%s] not allowed", new Object[]{vc.getOutputName()});
            }
            if (withDotSupport.containsKey(vc.getOutputName()) || withoutDotSupport.containsKey(vc.getOutputName())) {
                throw new IAE("Duplicate virtualColumn name[%s]", new Object[]{vc.getOutputName()});
            }
            if (vc.usesDotNotation()) {
                withDotSupport.put(vc.getOutputName(), vc);
                continue;
            }
            withoutDotSupport.put(vc.getOutputName(), vc);
        }
        return new VirtualColumns((List<VirtualColumn>)ImmutableList.copyOf(virtualColumns), withDotSupport, withoutDotSupport);
    }

    public static VirtualColumns nullToEmpty(@Nullable VirtualColumns virtualColumns) {
        return virtualColumns == null ? EMPTY : virtualColumns;
    }

    private VirtualColumns(List<VirtualColumn> virtualColumns, Map<String, VirtualColumn> withDotSupport, Map<String, VirtualColumn> withoutDotSupport) {
        this.virtualColumns = virtualColumns;
        this.withDotSupport = withDotSupport;
        this.withoutDotSupport = withoutDotSupport;
        for (VirtualColumn virtualColumn : virtualColumns) {
            this.detectCycles(virtualColumn, null);
        }
    }

    public boolean exists(String columnName) {
        return this.getVirtualColumn(columnName) != null;
    }

    @Nullable
    public VirtualColumn getVirtualColumn(String columnName) {
        VirtualColumn vc = this.withoutDotSupport.get(columnName);
        if (vc != null) {
            return vc;
        }
        String baseColumnName = (String)VirtualColumns.splitColumnName((String)columnName).lhs;
        return this.withDotSupport.get(baseColumnName);
    }

    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory factory) {
        VirtualColumn virtualColumn = this.getVirtualColumn(dimensionSpec.getDimension());
        if (virtualColumn == null) {
            throw new IAE("No such virtual column[%s]", new Object[]{dimensionSpec.getDimension()});
        }
        DimensionSelector selector = virtualColumn.makeDimensionSelector(dimensionSpec, factory);
        Preconditions.checkNotNull((Object)selector, (Object)"selector");
        return selector;
    }

    @Nullable
    public BitmapIndex getBitmapIndex(String columnName, ColumnSelector columnSelector) {
        VirtualColumn virtualColumn = this.getVirtualColumn(columnName);
        if (virtualColumn == null) {
            throw new IAE("No such virtual column[%s]", new Object[]{columnName});
        }
        return virtualColumn.capabilities(columnName).hasBitmapIndexes() ? virtualColumn.getBitmapIndex(columnName, columnSelector) : null;
    }

    @Nullable
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelector columnSelector, ReadableOffset offset) {
        VirtualColumn virtualColumn = this.getVirtualColumn(dimensionSpec.getDimension());
        if (virtualColumn == null) {
            throw new IAE("No such virtual column[%s]", new Object[]{dimensionSpec.getDimension()});
        }
        return virtualColumn.makeDimensionSelector(dimensionSpec, columnSelector, offset);
    }

    @Nullable
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelector columnSelector, ReadableOffset offset) {
        VirtualColumn virtualColumn = this.getVirtualColumn(columnName);
        if (virtualColumn == null) {
            throw new IAE("No such virtual column[%s]", new Object[]{columnName});
        }
        return virtualColumn.makeColumnValueSelector(columnName, columnSelector, offset);
    }

    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
        VirtualColumn virtualColumn = this.getVirtualColumn(columnName);
        if (virtualColumn == null) {
            throw new IAE("No such virtual column[%s]", new Object[]{columnName});
        }
        ColumnValueSelector<?> selector = virtualColumn.makeColumnValueSelector(columnName, factory);
        Preconditions.checkNotNull(selector, (Object)"selector");
        return selector;
    }

    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        VirtualColumn virtualColumn = this.getVirtualColumn(columnName);
        if (virtualColumn != null) {
            return (ColumnCapabilities)Preconditions.checkNotNull((Object)virtualColumn.capabilities(columnName), (String)"capabilities for column[%s]", (Object[])new Object[]{columnName});
        }
        return null;
    }

    @Nullable
    public ColumnCapabilities getColumnCapabilitiesWithFallback(StorageAdapter adapter, String columnName) {
        ColumnCapabilities virtualColumnCapabilities = this.getColumnCapabilities(columnName);
        if (virtualColumnCapabilities != null) {
            return virtualColumnCapabilities;
        }
        return adapter.getColumnCapabilities(columnName);
    }

    @JsonValue
    public VirtualColumn[] getVirtualColumns() {
        return this.virtualColumns.toArray(new VirtualColumn[0]);
    }

    public int size() {
        return this.virtualColumns.size();
    }

    public ColumnSelectorFactory wrap(ColumnSelectorFactory baseFactory) {
        if (this.virtualColumns.isEmpty()) {
            return baseFactory;
        }
        return new VirtualizedColumnSelectorFactory(baseFactory, this);
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(0).appendCacheablesIgnoringOrder(this.virtualColumns).build();
    }

    private void detectCycles(VirtualColumn virtualColumn, @Nullable Set<String> columnNames) {
        HashSet nextSet = columnNames == null ? Sets.newHashSet((Object[])new String[]{virtualColumn.getOutputName()}) : Sets.newHashSet(columnNames);
        for (String columnName : virtualColumn.requiredColumns()) {
            if (!nextSet.add(columnName)) {
                throw new IAE("Self-referential column[%s]", new Object[]{columnName});
            }
            VirtualColumn dependency = this.getVirtualColumn(columnName);
            if (dependency == null) continue;
            this.detectCycles(dependency, nextSet);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualColumns that = (VirtualColumns)o;
        return this.virtualColumns.equals(that.virtualColumns);
    }

    public int hashCode() {
        return this.virtualColumns.hashCode();
    }

    public String toString() {
        return this.virtualColumns.toString();
    }
}

