/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.generator;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.segment.generator.ColumnValueGenerator;
import org.apache.druid.segment.generator.GeneratorColumnSchema;
import org.joda.time.Interval;

public class DataGenerator {
    private final List<GeneratorColumnSchema> columnSchemas;
    private final long seed;
    private List<ColumnValueGenerator> columnGenerators;
    private final long startTime;
    private final long endTime;
    private final int numConsecutiveTimestamps;
    private final double timestampIncrement;
    private double currentTime;
    private int timeCounter;
    private List<String> dimensionNames;

    public DataGenerator(List<GeneratorColumnSchema> columnSchemas, long seed, long startTime, int numConsecutiveTimestamps, Double timestampIncrement) {
        this.columnSchemas = columnSchemas;
        this.seed = seed;
        this.startTime = startTime;
        this.endTime = Long.MAX_VALUE;
        this.numConsecutiveTimestamps = numConsecutiveTimestamps;
        this.timestampIncrement = timestampIncrement;
        this.currentTime = startTime;
        this.init();
    }

    public DataGenerator(List<GeneratorColumnSchema> columnSchemas, long seed, Interval interval, int numRows) {
        this.columnSchemas = columnSchemas;
        this.seed = seed;
        this.startTime = interval.getStartMillis();
        this.endTime = interval.getEndMillis() - 1L;
        Preconditions.checkArgument((this.endTime >= this.startTime ? 1 : 0) != 0, (Object)"endTime >= startTime");
        long timeDelta = this.endTime - this.startTime;
        this.timestampIncrement = (double)timeDelta / ((double)numRows * 1.0);
        this.numConsecutiveTimestamps = 0;
        this.init();
    }

    public InputRow nextRow() {
        HashMap<String, Object> event = new HashMap<String, Object>();
        for (ColumnValueGenerator generator : this.columnGenerators) {
            event.put(generator.getSchema().getName(), generator.generateRowValue());
        }
        MapBasedInputRow row = new MapBasedInputRow(this.nextTimestamp(), this.dimensionNames, event);
        return row;
    }

    private void init() {
        this.timeCounter = 0;
        this.currentTime = this.startTime;
        this.dimensionNames = new ArrayList<String>();
        for (GeneratorColumnSchema schema : this.columnSchemas) {
            if (schema.isMetric()) continue;
            this.dimensionNames.add(schema.getName());
        }
        this.columnGenerators = new ArrayList<ColumnValueGenerator>();
        this.columnGenerators.addAll(Lists.transform(this.columnSchemas, (Function)new Function<GeneratorColumnSchema, ColumnValueGenerator>(){

            public ColumnValueGenerator apply(GeneratorColumnSchema input) {
                return input.makeGenerator(DataGenerator.this.seed);
            }
        }));
    }

    private long nextTimestamp() {
        long newMillis;
        ++this.timeCounter;
        if (this.timeCounter > this.numConsecutiveTimestamps) {
            this.currentTime += this.timestampIncrement;
            this.timeCounter = 0;
        }
        if ((newMillis = Math.round(this.currentTime)) > this.endTime) {
            return this.endTime;
        }
        return newMillis;
    }
}

