/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.generator;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.generator.GeneratorColumnSchema;
import org.joda.time.Interval;

public class GeneratorSchemaInfo {
    private List<GeneratorColumnSchema> columnSchemas;
    private List<AggregatorFactory> aggs;
    private Interval dataInterval;
    private boolean withRollup;

    public GeneratorSchemaInfo(List<GeneratorColumnSchema> columnSchemas, List<AggregatorFactory> aggs, Interval dataInterval, boolean withRollup) {
        this.columnSchemas = columnSchemas;
        this.aggs = aggs;
        this.dataInterval = dataInterval;
        this.withRollup = withRollup;
    }

    public List<GeneratorColumnSchema> getColumnSchemas() {
        return this.columnSchemas;
    }

    public DimensionsSpec getDimensionsSpec() {
        List specs = this.getColumnSchemas().stream().filter(x -> !x.isMetric()).map(GeneratorColumnSchema::getDimensionSchema).collect(Collectors.toList());
        return new DimensionsSpec(specs);
    }

    public List<AggregatorFactory> getAggs() {
        return this.aggs;
    }

    public AggregatorFactory[] getAggsArray() {
        return this.aggs.toArray(new AggregatorFactory[0]);
    }

    public Interval getDataInterval() {
        return this.dataInterval;
    }

    public boolean isWithRollup() {
        return this.withRollup;
    }

    public String toString() {
        return "BenchmarkSchemaInfo{columnSchemas=" + this.columnSchemas + ", aggs=" + this.aggs + ", dataInterval=" + this.dataInterval + ", withRollup=" + this.withRollup + '}';
    }
}

