/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.Joinables;

public class JoinableClauses {
    @Nonnull
    private final List<JoinableClause> joinableClauses;

    public static JoinableClauses createClauses(List<PreJoinableClause> preClauses, JoinableFactory joinableFactory) {
        JoinableClauses.checkPreJoinableClausesForDuplicatesAndShadowing(preClauses);
        List<JoinableClause> joinableClauses = preClauses.stream().map(preJoinableClause -> {
            Optional<Joinable> joinable = joinableFactory.build(preJoinableClause.getDataSource(), preJoinableClause.getCondition());
            return new JoinableClause(preJoinableClause.getPrefix(), joinable.orElseThrow(() -> new ISE("dataSource is not joinable: %s", new Object[]{preJoinableClause.getDataSource()})), preJoinableClause.getJoinType(), preJoinableClause.getCondition());
        }).collect(Collectors.toList());
        return new JoinableClauses(joinableClauses);
    }

    public static JoinableClauses fromList(List<JoinableClause> clauses) {
        return new JoinableClauses(clauses);
    }

    private JoinableClauses(@Nonnull List<JoinableClause> joinableClauses) {
        this.joinableClauses = joinableClauses;
    }

    @Nonnull
    public List<JoinableClause> getJoinableClauses() {
        return this.joinableClauses;
    }

    public void splitVirtualColumns(VirtualColumns virtualColumns, List<VirtualColumn> preJoinVirtualColumns, List<VirtualColumn> postJoinVirtualColumns) {
        for (VirtualColumn virtualColumn : virtualColumns.getVirtualColumns()) {
            if (this.areSomeColumnsFromJoin(virtualColumn.requiredColumns())) {
                postJoinVirtualColumns.add(virtualColumn);
                continue;
            }
            preJoinVirtualColumns.add(virtualColumn);
        }
    }

    public boolean areSomeColumnsFromJoin(Collection<String> columns) {
        for (String column : columns) {
            if (this.getColumnFromJoinIfExists(column) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public JoinableClause getColumnFromJoinIfExists(String column) {
        for (JoinableClause joinableClause : this.joinableClauses) {
            if (!joinableClause.includesColumn(column)) continue;
            return joinableClause;
        }
        return null;
    }

    private static void checkPreJoinableClausesForDuplicatesAndShadowing(List<PreJoinableClause> preJoinableClauses) {
        ArrayList<String> prefixes = new ArrayList<String>();
        for (PreJoinableClause clause : preJoinableClauses) {
            prefixes.add(clause.getPrefix());
        }
        Joinables.checkPrefixesForDuplicatesAndShadowing(prefixes);
    }
}

