/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.base.Predicate;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.SingleIndexedInt;
import org.apache.druid.segment.join.table.IndexedTable;

public class IndexedTableDimensionSelector
implements DimensionSelector {
    private final IndexedTable table;
    private final IntSupplier currentRow;
    @Nullable
    private final ExtractionFn extractionFn;
    private final IndexedTable.Reader columnReader;
    private final SingleIndexedInt currentIndexedInts;

    IndexedTableDimensionSelector(IndexedTable table, IntSupplier currentRow, int columnNumber, @Nullable ExtractionFn extractionFn) {
        this.table = table;
        this.currentRow = currentRow;
        this.extractionFn = extractionFn;
        this.columnReader = table.columnReader(columnNumber);
        this.currentIndexedInts = new SingleIndexedInt();
    }

    @Override
    public IndexedInts getRow() {
        int rowNum = this.currentRow.getAsInt();
        if (rowNum == -1) {
            this.currentIndexedInts.setValue(this.table.numRows());
        } else {
            this.currentIndexedInts.setValue(rowNum);
        }
        return this.currentIndexedInts;
    }

    @Override
    public ValueMatcher makeValueMatcher(@Nullable String value) {
        return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, value);
    }

    @Override
    public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
        return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicate);
    }

    @Override
    public int getValueCardinality() {
        return IndexedTableDimensionSelector.computeDimensionSelectorCardinality(this.table);
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        String value = id == this.table.numRows() ? null : DimensionHandlerUtils.convertObjectToString(this.columnReader.read(id));
        if (this.extractionFn == null) {
            return value;
        }
        return this.extractionFn.apply(value);
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return true;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return null;
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.lookupName(this.currentRow.getAsInt());
    }

    @Override
    public Class<?> classOfObject() {
        return String.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("table", this.table);
        inspector.visit("extractionFn", this.extractionFn);
    }

    static int computeDimensionSelectorCardinality(IndexedTable table) {
        if (table.numRows() == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Table is too large");
        }
        return table.numRows() + 1;
    }
}

