/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFileAttribute;
import org.apache.druid.data.input.SplitHintSpec;

public class MaxSizeSplitHintSpec
implements SplitHintSpec {
    public static final String TYPE = "maxSize";
    @VisibleForTesting
    static final long DEFAULT_MAX_SPLIT_SIZE = 0x20000000L;
    private final long maxSplitSize;

    @JsonCreator
    public MaxSizeSplitHintSpec(@JsonProperty(value="maxSplitSize") @Nullable Long maxSplitSize) {
        this.maxSplitSize = maxSplitSize == null ? 0x20000000L : maxSplitSize;
    }

    @JsonProperty
    public long getMaxSplitSize() {
        return this.maxSplitSize;
    }

    @Override
    public <T> Iterator<List<T>> split(Iterator<T> inputIterator, Function<T, InputFileAttribute> inputAttributeExtractor) {
        UnmodifiableIterator nonEmptyFileOnlyIterator = Iterators.filter(inputIterator, input -> ((InputFileAttribute)inputAttributeExtractor.apply(input)).getSize() > 0L);
        return new Iterator<List<T>>((Iterator)nonEmptyFileOnlyIterator, inputAttributeExtractor){
            private T peeking;
            final /* synthetic */ Iterator val$nonEmptyFileOnlyIterator;
            final /* synthetic */ Function val$inputAttributeExtractor;
            {
                this.val$nonEmptyFileOnlyIterator = iterator;
                this.val$inputAttributeExtractor = function;
            }

            @Override
            public boolean hasNext() {
                return this.peeking != null || this.val$nonEmptyFileOnlyIterator.hasNext();
            }

            @Override
            public List<T> next() {
                long size;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ArrayList current = new ArrayList();
                for (long splitSize = 0L; splitSize < MaxSizeSplitHintSpec.this.maxSplitSize && (this.peeking != null || this.val$nonEmptyFileOnlyIterator.hasNext()); splitSize += size) {
                    if (this.peeking == null) {
                        this.peeking = this.val$nonEmptyFileOnlyIterator.next();
                    }
                    size = ((InputFileAttribute)this.val$inputAttributeExtractor.apply(this.peeking)).getSize();
                    if (!current.isEmpty() && splitSize + size >= MaxSizeSplitHintSpec.this.maxSplitSize) break;
                    current.add(this.peeking);
                    this.peeking = null;
                }
                assert (!current.isEmpty());
                return current;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaxSizeSplitHintSpec that = (MaxSizeSplitHintSpec)o;
        return this.maxSplitSize == that.maxSplitSize;
    }

    public int hashCode() {
        return Objects.hash(this.maxSplitSize);
    }
}

